/*
 * Decompiled with CFR 0.152.
 */
package javatester;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;

public class TestJavaGUI {
    public static void main(String[] args) {
        if (args.length > 0) {
            int[] reqVersion = TestJavaGUI.getVersion(args[0], 0);
            int[] curVersion = TestJavaGUI.getVersion(System.getProperty("java.version"), reqVersion.length);
            int i = 0;
            while (i < reqVersion.length) {
                if (curVersion[i] > reqVersion[i]) break;
                if (curVersion[i] < reqVersion[i]) {
                    TestJavaGUI.displayErrorMessage(args[0], System.getProperty("java.version"));
                }
                ++i;
            }
        }
    }

    private static int[] getVersion(String versionStr, int minPos) {
        StringTokenizer tk = new StringTokenizer(versionStr, ".");
        int count = tk.countTokens();
        String[] parts = new String[count];
        int i = 0;
        while (i < count) {
            parts[i] = tk.nextToken();
            ++i;
        }
        int[] result = new int[Math.max(parts.length, minPos)];
        int i2 = 0;
        while (i2 < parts.length) {
            try {
                result[i2] = Integer.parseInt(parts[i2]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            ++i2;
        }
        return result;
    }

    private static void displayErrorMessage(String minVersion, String curVersion) {
        Frame frame = new Frame("Error");
        frame.setLayout(new GridLayout(3, 1));
        Label lbl1 = new Label("This application requires Java version " + minVersion + " or greater.");
        frame.add(lbl1);
        Label lbl2 = new Label("Currently only Java version " + curVersion + " is installed.");
        frame.add(lbl2);
        Label lbl3 = new Label("Please go to http://www.java.com to download and install the latest Java version.");
        frame.add(lbl3);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(1);
            }
        });
        frame.pack();
        Dimension sDim = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension fDim = frame.getSize();
        frame.setLocation((sDim.width - fDim.width) / 2, (sDim.height - fDim.height) / 2);
        frame.setVisible(true);
    }
}

