/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;
import org.corebounce.common.dsp.iir.IIRFilterType;

class NotchFilter
extends IIRFilterType {
    private final DFilterFrame dFilterFrame;
    double wc;
    double a;
    double b;
    double bw;

    NotchFilter(DFilterFrame dFilterFrame) {
        super(dFilterFrame);
        this.dFilterFrame = dFilterFrame;
    }

    int select() {
        this.dFilterFrame.auxLabels[0].setText("Notch Frequency");
        this.dFilterFrame.auxBars[0].setValue(500);
        this.dFilterFrame.auxLabels[1].setText("Bandwidth");
        this.dFilterFrame.auxBars[1].setValue(900);
        return 2;
    }

    void setup() {
        this.wc = (double)this.dFilterFrame.auxBars[0].getValue() * Math.PI / 1000.0;
        this.bw = (double)this.dFilterFrame.auxBars[1].getValue() * Math.PI / 2000.0;
        this.a = (1.0 - Math.tan(this.bw / 2.0)) / (1.0 + Math.tan(this.bw / 2.0));
        this.b = Math.cos(this.wc);
    }

    void getPole(int i, Complex c1) {
        c1.set(-4.0 * this.a + (this.b + this.a * this.b) * (this.b + this.a * this.b));
        c1.sqrt();
        if (i == 1) {
            c1.mult(-1.0);
        }
        c1.add(this.b + this.a * this.b);
        c1.mult(0.5);
    }

    int getPoleCount() {
        return 2;
    }

    void getInfo(String[] x) {
        x[0] = "Notch (IIR)";
        x[1] = "Notch Frequency: " + this.dFilterFrame.getOmegaText(this.wc);
        x[2] = "Bandwidth: " + this.dFilterFrame.getOmegaText(this.bw);
    }

    int getZeroCount() {
        return 2;
    }

    void getZero(int i, Complex c1) {
        c1.set(this.b * this.b - 1.0);
        c1.sqrt();
        if (i == 1) {
            c1.mult(-1.0);
        }
        c1.add(this.b);
    }
}

