/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.iir;

import org.corebounce.common.dsp.iir.Complex;
import org.corebounce.common.dsp.iir.DFilterFrame;
import org.corebounce.common.dsp.iir.IIRFilterType;

class ResonatorFilter
extends IIRFilterType {
    private final DFilterFrame dFilterFrame;
    double r;
    double wc;

    ResonatorFilter(DFilterFrame dFilterFrame) {
        super(dFilterFrame);
        this.dFilterFrame = dFilterFrame;
    }

    int select() {
        this.dFilterFrame.auxLabels[0].setText("Resonant Frequency");
        this.dFilterFrame.auxBars[0].setValue(500);
        this.dFilterFrame.auxLabels[1].setText("Sharpness");
        this.dFilterFrame.auxBars[1].setValue(900);
        return 2;
    }

    void setup() {
        this.wc = (double)this.dFilterFrame.auxBars[0].getValue() * Math.PI / 1000.0;
        double rolldb = (double)(-this.dFilterFrame.auxBars[1].getValue() * 3) / 1000.0;
        this.r = 1.0 - Math.pow(10.0, rolldb);
    }

    void getPole(int i, Complex c1) {
        c1.setMagPhase(this.r, i == 1 ? -this.wc : this.wc);
    }

    int getPoleCount() {
        return 2;
    }

    void getInfo(String[] x) {
        x[0] = "Reson (IIR)";
        x[1] = "Res. Frequency: " + this.dFilterFrame.getOmegaText(this.wc);
    }
}

