/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.math;

public class Statistics {
    private double sum;
    private double sumSquare;
    private int count;

    public void add(double value) {
        this.sum += value;
        this.sumSquare += value * value;
        ++this.count;
    }

    public void remove(double value) {
        this.sum -= value;
        this.sumSquare -= value * value;
        --this.count;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSumSquare() {
        return this.sumSquare;
    }

    public int getCount() {
        return this.count;
    }

    public double getMean() {
        return this.sum / (double)this.count;
    }

    public double getVariance() {
        double mean = this.getMean();
        return (this.sumSquare - mean * mean) / (double)this.count;
    }

    public double getStdDeviation() {
        return Math.sqrt(this.getVariance());
    }

    public void reset() {
        this.count = 0;
        this.sum = 0.0;
        this.sumSquare = 0.0;
    }
}

