/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import javax.sound.sampled.AudioFormat;

public class MultiChanAudioSourceFork {
    private final IMultiChanAudioSource target;
    private final int nbReaders;
    private final int nbChannels;
    private final IMultiChanAudioSource[] sources;
    private float[][] buffer;
    private int size;
    private int capacity;
    private int[] indexes;

    public MultiChanAudioSourceFork(IMultiChanAudioSource target, int nbReaders, int nbChannels) {
        this.target = target;
        this.nbReaders = nbReaders;
        this.nbChannels = nbChannels;
        this.indexes = new int[nbReaders];
        this.buffer = new float[nbChannels][0];
        this.size = 0;
        this.capacity = 0;
        this.sources = new IMultiChanAudioSource[nbReaders];
        int i = 0;
        while (i < nbReaders) {
            this.sources[i] = new ReaderSource(i);
            ++i;
        }
    }

    public IMultiChanAudioSource getSource(int readerNum) {
        return this.sources[readerNum];
    }

    private int readSamples(int readerNum, float[][] output) {
        float[][] toAdd;
        int read;
        int remaining;
        int amount = output[0].length;
        if (this.indexes[readerNum] + amount > this.size) {
            int minIndex = this.capacity;
            int i = 0;
            while (i < this.nbReaders) {
                if (this.indexes[i] < minIndex) {
                    minIndex = this.indexes[i];
                }
                ++i;
            }
            if (minIndex > 0) {
                int chan = 0;
                while (chan < this.nbChannels) {
                    System.arraycopy(this.buffer[chan], minIndex, this.buffer[chan], 0, this.size - minIndex);
                    ++chan;
                }
                this.size -= minIndex;
                i = 0;
                while (i < this.nbReaders) {
                    int n = i++;
                    this.indexes[n] = this.indexes[n] - minIndex;
                }
            }
        }
        if (this.indexes[readerNum] + amount > this.capacity) {
            remaining = Math.max(this.indexes[readerNum] + amount - this.size, this.capacity);
            float[][] toAdd2 = new float[this.nbChannels][remaining];
            read = this.target.readSamples(toAdd2);
            if (read > 0) {
                float[][] newBuffer = new float[this.nbChannels][this.size + read];
                int chan = 0;
                while (chan < this.nbChannels) {
                    System.arraycopy(this.buffer[chan], 0, newBuffer[chan], 0, this.size);
                    System.arraycopy(toAdd2[chan], 0, newBuffer[chan], this.size, read);
                    ++chan;
                }
                this.buffer = newBuffer;
                this.capacity = newBuffer[0].length;
                this.size += read;
            }
        } else if (this.indexes[readerNum] + amount > this.size && (read = this.target.readSamples(toAdd = new float[this.nbChannels][remaining = this.capacity - this.size])) > 0) {
            int chan = 0;
            while (chan < this.nbChannels) {
                System.arraycopy(toAdd[chan], 0, this.buffer[chan], this.size, read);
                ++chan;
            }
            this.size += read;
        }
        if (this.indexes[readerNum] + amount > this.size) {
            amount = this.size - this.indexes[readerNum];
        }
        int chan = 0;
        while (chan < this.nbChannels) {
            System.arraycopy(this.buffer[chan], this.indexes[readerNum], output[chan], 0, amount);
            ++chan;
        }
        int n = readerNum;
        this.indexes[n] = this.indexes[n] + amount;
        return amount;
    }

    class ReaderSource
    implements IMultiChanAudioSource {
        private final int readerNum;

        public ReaderSource(int readerNum) {
            this.readerNum = readerNum;
        }

        public AudioFormat getAudioFormat() {
            return MultiChanAudioSourceFork.this.target.getAudioFormat();
        }

        public int readSamples(float[][] target) {
            return MultiChanAudioSourceFork.this.readSamples(this.readerNum, target);
        }
    }
}

