/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.Icon;
import org.corebounce.common.gui.IconLoader;
import org.corebounce.common.utils.PlatformType;

public class Platform {
    private static int javaMajorVersion;
    private static int javaMinorVersion;
    private static String javaRevision;
    private static String osName;
    private static boolean interpreted;

    static {
        String javaVersion = System.getProperty("java.version");
        try {
            String[] tokens = javaVersion.split("\\.");
            javaMajorVersion = Integer.parseInt(tokens[0]);
            javaMinorVersion = Integer.parseInt(tokens[1]);
            javaRevision = tokens[2];
            try {
                RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                List<String> arguments = runtimeMxBean.getInputArguments();
                interpreted = arguments.contains("-Xint");
            }
            catch (Throwable throwable) {}
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static PlatformType getPlatform() {
        if (osName == null) {
            osName = System.getProperty("os.name").toLowerCase();
        }
        if (osName.contains("windows")) {
            return PlatformType.WINDOWS;
        }
        if (osName.contains("mac")) {
            return PlatformType.MACOSX;
        }
        if (osName.contains("linux")) {
            return PlatformType.LINUX;
        }
        if (osName.contains("solaris") || osName.contains("sunos")) {
            return PlatformType.SOLARIS;
        }
        if (osName.contains("freebsd")) {
            return PlatformType.FREEBSD;
        }
        if (osName.contains("os/2")) {
            return PlatformType.OS2;
        }
        return PlatformType.UNKNOWN;
    }

    public static boolean isUnixLikePlatform() {
        PlatformType[] unixPlatforms = new PlatformType[]{PlatformType.SOLARIS, PlatformType.FREEBSD, PlatformType.LINUX};
        PlatformType platformType = Platform.getPlatform();
        return new HashSet<PlatformType>(Arrays.asList(unixPlatforms)).contains((Object)platformType);
    }

    public static boolean isMacOsX() {
        return Platform.getPlatform().equals((Object)PlatformType.MACOSX);
    }

    public static boolean isWindows() {
        return Platform.getPlatform().equals((Object)PlatformType.WINDOWS);
    }

    public static boolean isGcj() {
        String javaVmName = System.getProperty("java.vm.name");
        return javaVmName != null && javaVmName.toLowerCase().contains("gnu libgcj");
    }

    public static boolean isOpenJdk() {
        String javaVmName = System.getProperty("java.vm.name");
        return javaVmName != null && javaVmName.toLowerCase().contains("openjdk");
    }

    public static boolean isSupportedPlatform() {
        String javaVersion;
        PlatformType pt = Platform.getPlatform();
        if (pt != PlatformType.WINDOWS && pt != PlatformType.LINUX && pt != PlatformType.MACOSX) {
            return false;
        }
        if (pt != PlatformType.MACOSX && pt != PlatformType.SOLARIS) {
            String arch = System.getProperty("os.arch");
            String[] archs = new String[]{"x86", "x64", "x86_64", "amd64", "i386"};
            boolean supported = false;
            String[] stringArray = archs;
            int n = archs.length;
            int n2 = 0;
            while (n2 < n) {
                String suppArch = stringArray[n2];
                if (suppArch.equals(arch)) {
                    supported = true;
                }
                ++n2;
            }
            if (!supported) {
                return false;
            }
        }
        return !(javaVersion = System.getProperty("java.version")).startsWith("1.5.") && !javaVersion.equals("1.5");
    }

    public static Icon getPlatformIcon(PlatformType platformType) {
        return IconLoader.getIcon(Platform.class, "icons/" + platformType.name().toLowerCase() + ".png", 16);
    }

    public static int getJavaMajorVersion() {
        return javaMajorVersion;
    }

    public static int getJavaMinorVersion() {
        return javaMinorVersion;
    }

    public static String getJavaRevision() {
        return javaRevision;
    }

    public static boolean isBelowJava16() {
        return javaMajorVersion <= 1 && javaMinorVersion < 6;
    }

    public static boolean isBelowJava17() {
        return javaMajorVersion <= 1 && javaMinorVersion < 7;
    }

    public static boolean isBelowJava18() {
        return javaMajorVersion <= 1 && javaMinorVersion < 8;
    }

    public static boolean isInterpreted() {
        return interpreted;
    }

    public static void lowerPriority() {
        if (Platform.isWindows() && Runtime.getRuntime().availableProcessors() <= 1) {
            Thread.currentThread().setPriority(2);
        }
    }

    public static void normalPriority() {
        if (Platform.isWindows() && Runtime.getRuntime().availableProcessors() <= 1) {
            Thread.currentThread().setPriority(5);
        }
    }

    public static void yield() {
        if (Platform.isWindows()) {
            Thread.yield();
        }
    }
}

