/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.antarctica;

import ch.tachyon.tunnel.utils.IProgressMonitor;
import ch.tachyon.tunnel.utils.OperationAbortedException;

public class ConsoleProgressMonitor
implements IProgressMonitor {
    private final int LENGTH = 78;
    private int lastPercent = 0;

    public ConsoleProgressMonitor() {
        System.out.print("< 0% ");
        int i = 0;
        while (i < 70) {
            System.out.print("-");
            ++i;
        }
        System.out.println(" 100% >");
        System.out.print("< ");
    }

    public void setProgress(double current, double total) throws OperationAbortedException {
        int percent = (int)(current * 78.0 / total + 0.5);
        while (this.lastPercent < percent) {
            System.out.print("=");
            ++this.lastPercent;
            if (this.lastPercent != 78) continue;
            System.out.println(" >");
        }
    }
}

