/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.Dish;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.LockedMultiScaleFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IAnalysisSynthesisFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.sonics.effect.utils.buffer.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

public class AdaptiveFourierEngine
implements IFourierEngine,
IAnalysisSynthesisFourierEngine {
    static final float NOISE_AMPLIFICATION = 1.5f;
    private static final String DELAYER_SERIAL_SECTION_NAME = String.valueOf(LockedMultiScaleFourierEngine.class.getName()) + " delayer";
    private FourierSpec specs;
    private float[][] mChan;
    private Fork fork;
    private boolean ownForkAndDish = true;
    private Dish dish;
    private int inChunkSize;
    private int outChunkSize;
    private int nbScales;
    private PyramidAnalyzer analyzer;
    private PyramidSynthesizer synthesizer;
    private float[] output;
    private float[] lockedOutput;
    private ConcurrentDelayBuffer orgDelayer;
    private ISerialSection orgDelayerSection;
    private PyramidAnalyzer orgAnalyzer;
    private float[] delayed;
    private transient float[][] scales;
    private transient Cmplx[][][] spectrums;
    private transient Cmplx[][][] orgSpectrums;
    private transient long clock;

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void setForkAndDish(Fork fork, Dish dish) {
        this.fork = fork;
        this.dish = dish;
        this.ownForkAndDish = false;
    }

    public void startProcessing(IProcessingInfo info) {
        int overlap = (int)(this.specs.getOverlap() + 0.5f);
        this.inChunkSize = this.specs.getInputHopSize();
        this.outChunkSize = this.specs.getOutputHopSize();
        int outOverlap = (int)((float)overlap / this.specs.getTimeScale() + 0.5f);
        int[] scales = this.specs.getScales();
        this.nbScales = scales.length;
        if (this.fork == null) {
            this.fork = new Fork(1, this.specs.getSharpInfoSplit(), this.inChunkSize, false, this.specs.getNoiseMode(), 1.5f);
        }
        if (this.dish == null) {
            this.dish = new Dish(this.specs.getAdaptiveResolutions(), this.specs.getSplitFreqs(), this.specs.getNoiseSplitFreqs(), this.inChunkSize, AudioMath.adjustPowerOf2(this.specs.getDishFftSize(), 44100.0f, info.getSampleRate()), info.getSampleRate());
        }
        this.analyzer = new PyramidAnalyzer(scales, this.inChunkSize, overlap, this.specs.getAnalysisWindow());
        if (this.specs.isIncludeSynthesis()) {
            this.synthesizer = new PyramidSynthesizer(scales, this.outChunkSize, outOverlap, this.specs.getModifiedWindow(), this.specs.getSynthesisWindow(), this.specs.getPostFftProcessor(), this.specs.getSynthesisShrink(), this.specs.getEnergyCorrection(), this.specs.getTimeScale());
            this.synthesizer.setFourierLatency(this.specs.getFourierLatency());
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            int[] orgScales = scales;
            if (!this.specs.getRequiresSource()) {
                orgScales = new int[scales.length - 1];
                System.arraycopy(scales, 0, orgScales, 0, orgScales.length);
            }
            this.orgAnalyzer = new PyramidAnalyzer("orginal", orgScales, this.inChunkSize, overlap, this.specs.getAnalysisWindow());
        }
    }

    private void setupOrgDelayer(IMtContext mtContext) {
        int delayAmount = this.fork.getLatency() + this.dish.getLatency();
        int inputSize = this.fork.getInputSize();
        this.orgDelayer = new ConcurrentDelayBuffer(delayAmount, delayAmount + inputSize * mtContext.getSerialRunningMaxSkew(), inputSize);
    }

    public int getFixedChunkLength() {
        return this.inChunkSize;
    }

    public int getLatency() {
        int result = (int)((float)(this.fork.getLatency() + this.dish.getLatency()) * this.specs.getTimeScale() + 0.5f) + this.synthesizer.getLatency();
        return result += (int)((float)this.synthesizer.getBaseBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f);
    }

    public int getDishLatency() {
        return this.dish.getLatency();
    }

    public int getNbScales() {
        return this.specs.getNbScales();
    }

    public int getNbResolutions() {
        return this.specs.getNbScales();
    }

    public int getNbBins() {
        return -1;
    }

    public int getNbBins(int layer) {
        return this.specs.getScales()[layer] / 2 + 1;
    }

    public int getEffectiveResolution(int layer) {
        return (int)(this.specs.getSharpInfo().layerInfo[layer].getAnalysisResolution() + 0.5f);
    }

    public int getNumHops(int layer) {
        return this.analyzer.getNumHops(layer);
    }

    public int getInputHopSize() {
        return this.analyzer.getInputSize();
    }

    public int getDistanceBetweenFrames(int res) {
        return this.analyzer.getBlockSize(res) / this.analyzer.getOverlap();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.mChan = new float[1][];
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.delayed = new float[this.inChunkSize];
        }
        if (this.inChunkSize != this.outChunkSize) {
            this.output = new float[this.outChunkSize];
        }
        if (this.specs.getPostLockedProcessor() != null) {
            this.lockedOutput = new float[this.outChunkSize];
        }
        if (this.ownForkAndDish) {
            this.fork.init();
            this.dish.init();
        }
        this.analyzer.init();
        if (this.synthesizer != null) {
            this.synthesizer.init();
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgAnalyzer.init();
        }
    }

    public float[] process(float[] input, ISpectrumProcessor processor) {
        this.analyze(input);
        this.processSpectrums(processor);
        return this.synthesize(input);
    }

    public Cmplx[][][] analyze(float[] input) {
        this.mChan[0] = input;
        this.fork.process(this.mChan);
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            long delayerClock = this.orgDelayerSection.getClock();
            this.orgDelayer.push(input, delayerClock);
            this.orgDelayerSection.sync();
            this.orgDelayer.pop(this.delayed, delayerClock);
        }
        return this.analyzeUsing(this.fork.getOutputs(0), this.delayed);
    }

    public Cmplx[][][] analyzeUsing(float[][] layers, float[] input) {
        this.orgSpectrums = null;
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgSpectrums = this.orgAnalyzer.analyzeInEachRes(input);
        }
        float[][] scales = this.dish.process(layers);
        return this.analyzeUsing(scales);
    }

    public Cmplx[][][] analyzeUsing(float[][] scales, float[][] sources0) {
        this.orgSpectrums = null;
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            float[][] sources = new float[sources0.length][sources0[0].length];
            int i = 0;
            while (i < sources0.length) {
                sources[i] = sources0[sources0.length - 1 - i];
                ++i;
            }
            this.orgSpectrums = this.orgAnalyzer.analyze(sources);
        }
        return this.analyzeUsing(scales);
    }

    private Cmplx[][][] analyzeUsing(float[][] scales0) {
        if (this.scales == null || this.scales.length != this.nbScales) {
            this.scales = new float[this.nbScales][];
        }
        assert (this.scales.length == this.nbScales);
        int i = 0;
        while (i < this.nbScales) {
            this.scales[i] = scales0[this.nbScales - i - 1];
            ++i;
        }
        this.clock = this.analyzer.getClock();
        this.spectrums = this.analyzer.analyze(this.scales);
        if (this.specs.getAntiLeakage()) {
            int r = 0;
            while (r < this.nbScales - 1) {
                if (r >= this.specs.getNbUnLockedScales()) {
                    int k = 0;
                    while (k < this.spectrums[r].length) {
                        Cmplx[] orgSpectrum = this.orgSpectrums[r][k];
                        Cmplx[] spectrum = this.spectrums[r][k];
                        int i2 = 0;
                        while (i2 < spectrum.length) {
                            float sigMag = spectrum[i2].magApprox();
                            float orgMag = orgSpectrum[i2].magApprox();
                            if (orgMag < sigMag) {
                                spectrum[i2].mul(orgMag / sigMag);
                            }
                            ++i2;
                        }
                        ++k;
                    }
                }
                ++r;
            }
        }
        return this.spectrums;
    }

    public Cmplx[] getSpectrum(int scale, int hopIndex) {
        return this.analyzer.getSpectrum(this.specs.getNbScales() - 1 - scale)[hopIndex];
    }

    public void processSpectrums(ISpectrumProcessor processor) {
        int r = 0;
        while (r < this.spectrums.length) {
            Cmplx[][] sources = this.specs.getRequiresSource() ? this.orgSpectrums[r] : this.spectrums[r];
            Cmplx[][] frames = this.spectrums[r];
            int numHops = this.analyzer.getNumHops(r);
            assert (frames.length == numHops && sources.length == numHops);
            int k = 0;
            while (k < frames.length) {
                processor.process(r, r, sources[k], frames[k], k, this.clock * (long)numHops + (long)k);
                ++k;
            }
            ++r;
        }
    }

    public float[] synthesize(float[] input) {
        float[] output;
        float[] fArray = output = this.output == null ? input : this.output;
        if (this.specs.getPostLockedProcessor() == null) {
            this.synthesizer.synthesize(this.spectrums, output);
        } else {
            this.synthesizer.synthesize(this.spectrums, output, this.specs.getNbUnLockedScales(), this.lockedOutput);
            this.specs.getPostLockedProcessor().postProcess(this.lockedOutput, output);
            int i = 0;
            while (i < this.lockedOutput.length) {
                int n = i;
                output[n] = output[n] + this.lockedOutput[i];
                ++i;
            }
        }
        return output;
    }

    public void stopProcessing() {
        this.spectrums = null;
        this.orgSpectrums = null;
        this.mChan = null;
        this.fork = null;
        this.dish = null;
        this.analyzer = null;
        this.synthesizer = null;
        this.orgDelayer = null;
        this.orgAnalyzer = null;
        this.delayed = null;
        this.output = null;
        this.specs = null;
        this.scales = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        if (this.ownForkAndDish) {
            this.fork.createSerialSections(factory);
            this.dish.createSerialSections(factory);
        }
        this.analyzer.createSerialSections(factory);
        if (this.synthesizer != null) {
            this.synthesizer.createSerialSections(factory);
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.setupOrgDelayer(factory.getMtContext());
            this.orgDelayerSection = factory.createSerialSection(DELAYER_SERIAL_SECTION_NAME, this.orgDelayer);
            this.orgAnalyzer.createSerialSections(factory);
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        if (this.ownForkAndDish) {
            this.fork.setSerialSections(pool);
            this.dish.setSerialSections(pool);
        }
        this.analyzer.setSerialSections(pool);
        if (this.synthesizer != null) {
            this.synthesizer.setSerialSections(pool);
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgDelayerSection = pool.getSerialSection(DELAYER_SERIAL_SECTION_NAME);
            this.orgDelayer = (ConcurrentDelayBuffer)this.orgDelayerSection.getUserData();
            this.orgAnalyzer.setSerialSections(pool);
        }
    }
}

