/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.LockedMultiScaleFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IAnalysisSynthesisFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.base.pyramid.PyramidAnalyzer;
import ch.tachyon.sonics.effect.base.pyramid.PyramidSynthesizer;
import ch.tachyon.sonics.effect.utils.buffer.ConcurrentDelayBuffer;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;

public class MultiScaleFourierEngine
implements IFourierEngine,
IAnalysisSynthesisFourierEngine {
    private static final String DELAYER_SERIAL_SECTION_NAME = String.valueOf(LockedMultiScaleFourierEngine.class.getName()) + " delayer";
    private FourierSpec specs;
    private float[][] mChan;
    private Fork fork;
    private boolean ownFork = true;
    private int chunkSize;
    private PyramidAnalyzer analyzer;
    private PyramidSynthesizer synthesizer;
    private ConcurrentDelayBuffer orgDelayer;
    private ISerialSection orgDelayerSection;
    private PyramidAnalyzer orgAnalyzer;
    private float[][] layers;
    private float[] delayed;
    private transient Cmplx[][][] spectrums;
    private transient Cmplx[][][] orgSpectrums;
    private transient long clock;

    public void setSpecs(FourierSpec specs) {
        this.specs = specs;
    }

    public void setFork(Fork fork) {
        this.fork = fork;
        this.ownFork = false;
    }

    public void startProcessing(IProcessingInfo info) {
        this.chunkSize = this.specs.getInputHopSize();
        if (this.fork == null) {
            this.fork = new Fork(1, this.specs.getSharpInfo(), this.chunkSize, false, this.specs.getNoiseMode(), 1.7f);
        }
        this.analyzer = new PyramidAnalyzer(this.specs.getMultiScaleResolutions(), this.chunkSize, this.specs.getIntOverlap(), this.specs.getAnalysisWindow());
        if (this.specs.isIncludeSynthesis()) {
            this.synthesizer = new PyramidSynthesizer(this.specs.getMultiScaleResolutions(), this.chunkSize, this.specs.getIntOverlap(), this.specs.getModifiedWindow(), this.specs.getSynthesisWindow(), this.specs.getPostFftProcessor(), this.specs.getSynthesisShrink(), this.specs.getEnergyCorrection(), this.specs.getTimeScale());
            this.synthesizer.setFourierLatency(this.specs.getFourierLatency());
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgAnalyzer = new PyramidAnalyzer("source", this.specs.getOrgResolutions(), this.chunkSize, this.specs.getIntOverlap(), this.specs.getAnalysisWindow());
        }
    }

    private void setupSrcDelayer(IMtContext mtContext) {
        int delayAmount = this.fork.getLatency();
        int inputSize = this.specs.getInputHopSize();
        this.orgDelayer = new ConcurrentDelayBuffer(delayAmount, delayAmount + inputSize * mtContext.getSerialRunningMaxSkew(), inputSize);
    }

    public int getFixedChunkLength() {
        return this.chunkSize;
    }

    public int getLatency() {
        int result = (int)((float)this.fork.getLatency() * this.specs.getTimeScale() + 0.5f) + this.synthesizer.getLatency();
        return result += (int)((float)this.synthesizer.getBaseBlockSize() / 2.0f * (this.specs.getTimeScale() - 1.0f) + 0.5f);
    }

    public int getNbScales() {
        return this.specs.getNbLayers();
    }

    public int getNbResolutions() {
        return this.specs.getNbLayers();
    }

    public int getNbBins() {
        return -1;
    }

    public int getNbBins(int layer) {
        return AudioMath.getCeilingPowerOf2(this.specs.getMultiScaleResolutions()[layer]) / 2 + 1;
    }

    public int getEffectiveResolution(int layer) {
        return (int)(this.specs.getSharpInfo().layerInfo[layer].getAnalysisResolution() + 0.5f);
    }

    public int getNumHops(int scale) {
        return this.analyzer.getNumHops(scale);
    }

    public int getInputHopSize() {
        return this.specs.getSharpInfo().hopSize;
    }

    public int getDistanceBetweenFrames(int res) {
        return this.analyzer.getBlockSize(res) / this.analyzer.getOverlap();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.mChan = new float[1][];
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.delayed = new float[this.chunkSize];
        }
        this.layers = new float[this.specs.getNbLayers()][];
        if (this.ownFork) {
            this.fork.init();
        }
        this.analyzer.init();
        if (this.synthesizer != null) {
            this.synthesizer.init();
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgAnalyzer.init();
        }
    }

    public float[] process(float[] input, ISpectrumProcessor processor) {
        this.analyze(input);
        this.processSpectrums(processor);
        return this.synthesize(input);
    }

    public Cmplx[][][] analyze(float[] input) {
        this.mChan[0] = input;
        this.fork.process(this.mChan);
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            long delayerClock = this.orgDelayerSection.getClock();
            this.orgDelayer.push(input, delayerClock);
            this.orgDelayerSection.sync();
            this.orgDelayer.pop(this.delayed, delayerClock);
        }
        return this.analyzeUsing(this.fork.getOutputs(0), this.delayed);
    }

    public Cmplx[][][] analyzeUsing(float[][] layers0, float[] source) {
        this.orgSpectrums = null;
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            this.orgSpectrums = this.orgAnalyzer.analyzeInEachRes(source);
        }
        return this.analyzeUsing(layers0);
    }

    public Cmplx[][][] analyzeUsing(float[][] layers0, float[][] sources0) {
        this.orgSpectrums = null;
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            float[][] sources = new float[sources0.length][sources0[0].length];
            int i = 0;
            while (i < sources0.length) {
                sources[i] = sources0[sources0.length - 1 - i];
                ++i;
            }
            this.orgSpectrums = this.orgAnalyzer.analyze(sources);
        }
        return this.analyzeUsing(layers0);
    }

    private Cmplx[][][] analyzeUsing(float[][] layers0) {
        int nbLayers = this.specs.getNbLayers();
        int i = 0;
        while (i < nbLayers) {
            this.layers[i] = layers0[nbLayers - i - 1];
            ++i;
        }
        this.clock = this.analyzer.getClock();
        this.spectrums = this.analyzer.analyze(this.layers);
        if (this.specs.getAntiLeakage()) {
            int r = 0;
            while (r < nbLayers - 1) {
                int k = 0;
                while (k < this.spectrums[r].length) {
                    Cmplx[] orgSpectrum = this.orgSpectrums[r][k];
                    Cmplx[] spectrum = this.spectrums[r][k];
                    int i2 = 0;
                    while (i2 < spectrum.length) {
                        float sigMag = spectrum[i2].magApprox();
                        float orgMag = orgSpectrum[i2].magApprox();
                        if (orgMag < sigMag) {
                            spectrum[i2].mul(orgMag / sigMag);
                        }
                        ++i2;
                    }
                    ++k;
                }
                ++r;
            }
        }
        return this.spectrums;
    }

    public Cmplx[] getSpectrum(int layer, int hopIndex) {
        return this.analyzer.getSpectrum(this.specs.getNbLayers() - 1 - layer)[hopIndex];
    }

    public void processSpectrums(ISpectrumProcessor processor) {
        int r = 0;
        while (r < this.spectrums.length) {
            Cmplx[][] frames = this.spectrums[r];
            Cmplx[][] orgFrames = this.specs.getRequiresSource() ? this.orgSpectrums[r] : this.spectrums[r];
            int numHops = this.analyzer.getNumHops(r);
            assert (frames.length == numHops && orgFrames.length == numHops);
            int k = 0;
            while (k < frames.length) {
                processor.process(r, r, orgFrames[k], frames[k], k, this.clock * (long)numHops + (long)k);
                ++k;
            }
            ++r;
        }
    }

    public float[] synthesize(float[] data) {
        this.synthesizer.synthesize(this.spectrums, data);
        return data;
    }

    public void stopProcessing() {
        this.spectrums = null;
        this.orgSpectrums = null;
        this.mChan = null;
        this.fork = null;
        this.analyzer = null;
        this.orgAnalyzer = null;
        this.delayed = null;
        this.synthesizer = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        if (this.ownFork) {
            this.fork.createSerialSections(factory);
        }
        this.analyzer.createSerialSections(factory);
        if (this.synthesizer != null) {
            this.synthesizer.createSerialSections(factory);
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            if (this.ownFork) {
                this.setupSrcDelayer(factory.getMtContext());
                this.orgDelayerSection = factory.createSerialSection(DELAYER_SERIAL_SECTION_NAME, this.orgDelayer);
            }
            this.orgAnalyzer.createSerialSections(factory);
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        if (this.ownFork) {
            this.fork.setSerialSections(pool);
        }
        this.analyzer.setSerialSections(pool);
        if (this.synthesizer != null) {
            this.synthesizer.setSerialSections(pool);
        }
        if (this.specs.getAntiLeakage() || this.specs.getRequiresSource()) {
            if (this.ownFork) {
                this.orgDelayerSection = pool.getSerialSection(DELAYER_SERIAL_SECTION_NAME);
                this.orgDelayer = (ConcurrentDelayBuffer)this.orgDelayerSection.getUserData();
            }
            this.orgAnalyzer.setSerialSections(pool);
        }
    }
}

