/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.adaptive;

import ch.tachyon.sonics.effect.base.adaptive.KnifeInfo;
import ch.tachyon.sonics.effect.base.adaptive.LayerInfo;
import java.io.Serializable;
import java.util.Arrays;

public class SharpInfo
implements Serializable {
    public final int nbLayers;
    public final KnifeInfo[] knifeInfo;
    public final LayerInfo[] layerInfo;
    public final int blockSize;
    public final int hopSize;

    public SharpInfo(KnifeInfo[] knifeInfos, LayerInfo[] layerInfos) {
        if (knifeInfos.length + 1 != layerInfos.length) {
            throw new IllegalArgumentException("Sizes do not match");
        }
        this.nbLayers = layerInfos.length;
        this.knifeInfo = knifeInfos;
        this.layerInfo = layerInfos;
        SharpInfo.checkValidity(layerInfos);
        this.blockSize = layerInfos[0].blockSize;
        this.hopSize = layerInfos[0].hopSize;
    }

    public SharpInfo(float maxSize, int nbLayers, float shrink, float maxSynthesisSize, float minOverlap, float sampleRate) {
        this(maxSize, maxSize, nbLayers, shrink, maxSynthesisSize, minOverlap, sampleRate);
    }

    public SharpInfo(float maxSize, float minSize, int nbLayers, float shrink, float maxSynthesisSize, float minOverlap, float sampleRate) {
        this(maxSize, minSize, nbLayers, shrink, maxSynthesisSize, minOverlap, true, 1.0f, sampleRate);
    }

    public SharpInfo(float maxSize, int nbLayers, float shrink, float maxSynthesisSize, float minOverlap, boolean energyCorrection, float baseAnalysisShrink, float sampleRate) {
        this(maxSize, maxSize, nbLayers, shrink, maxSynthesisSize, minOverlap, energyCorrection, baseAnalysisShrink, sampleRate);
    }

    public SharpInfo(float maxSize, float minSize0, int nbLayers, float shrink, float maxSynthesisSize, float minOverlap, boolean energyCorrection, float baseAnalysisShrink, float sampleRate) {
        if (nbLayers < 1) {
            throw new IllegalArgumentException();
        }
        this.nbLayers = nbLayers;
        this.knifeInfo = new KnifeInfo[nbLayers - 1];
        if (nbLayers >= 2) {
            this.knifeInfo[0] = KnifeInfo.getInstance(0, sampleRate);
        }
        if (nbLayers >= 3) {
            this.knifeInfo[1] = KnifeInfo.getInstance(1, sampleRate);
        }
        if (nbLayers >= 4) {
            this.knifeInfo[2] = KnifeInfo.getInstance(2, sampleRate);
        }
        this.blockSize = SharpInfo.getFftSize(maxSize);
        float minSize = maxSize;
        int i = 1;
        while (i < nbLayers) {
            minSize /= shrink;
            ++i;
        }
        if (minSize > minSize0) {
            minSize = minSize0;
        }
        this.hopSize = SharpInfo.getHopSize(minSize, minOverlap);
        float curSize = maxSize / baseAnalysisShrink;
        this.layerInfo = new LayerInfo[nbLayers];
        int layer = nbLayers - 1;
        while (layer >= 0) {
            float analysisShrink = (float)this.blockSize / curSize;
            float synthesisShrink = analysisShrink / baseAnalysisShrink;
            float synthesisSize = (float)this.blockSize / synthesisShrink;
            if (synthesisSize > maxSynthesisSize) {
                synthesisShrink = (float)this.blockSize / maxSynthesisSize;
            }
            this.layerInfo[layer] = new LayerInfo(this.blockSize, this.hopSize, analysisShrink, synthesisShrink, energyCorrection);
            curSize /= shrink;
            --layer;
        }
    }

    public SharpInfo(int[] layerSizes, float maxSynthesisSize, float minOverlap, boolean energyCorrection, float baseAnalysisShrink, float sampleRate) {
        this.nbLayers = layerSizes.length;
        this.knifeInfo = new KnifeInfo[this.nbLayers - 1];
        if (this.nbLayers >= 2) {
            this.knifeInfo[0] = KnifeInfo.getInstance(0, sampleRate);
        }
        if (this.nbLayers >= 3) {
            this.knifeInfo[1] = KnifeInfo.getInstance(1, sampleRate);
        }
        if (this.nbLayers >= 4) {
            this.knifeInfo[2] = KnifeInfo.getInstance(2, sampleRate);
        }
        int maxSize = layerSizes[layerSizes.length - 1];
        this.blockSize = SharpInfo.getFftSize(maxSize);
        float minSize = layerSizes[0];
        this.hopSize = SharpInfo.getHopSize(minSize, minOverlap);
        this.layerInfo = new LayerInfo[this.nbLayers];
        int layer = this.nbLayers - 1;
        while (layer >= 0) {
            float curSize = (float)layerSizes[layer] / baseAnalysisShrink;
            float analysisShrink = (float)this.blockSize / curSize;
            float synthesisShrink = analysisShrink / baseAnalysisShrink;
            float synthesisSize = (float)this.blockSize / synthesisShrink;
            if (synthesisSize > maxSynthesisSize) {
                synthesisShrink = (float)this.blockSize / maxSynthesisSize;
            }
            this.layerInfo[layer] = new LayerInfo(this.blockSize, this.hopSize, analysisShrink, synthesisShrink, energyCorrection);
            --layer;
        }
    }

    public SharpInfo halfOverlapCopy(float synthesisShrinkMult) {
        LayerInfo[] layerInfo = new LayerInfo[this.layerInfo.length];
        int i = 0;
        while (i < layerInfo.length) {
            LayerInfo li = this.layerInfo[i];
            layerInfo[i] = new LayerInfo(li.blockSize, li.hopSize * 2, li.analysisShrink, li.synthesisShrink * synthesisShrinkMult, li.enableEnergyCorrection);
            ++i;
        }
        SharpInfo result = new SharpInfo(this.knifeInfo, layerInfo);
        return result;
    }

    public SharpInfo scaleCopy(float scale, float synthesisShrinkMult) {
        LayerInfo[] layerInfo = new LayerInfo[this.layerInfo.length];
        int i = 0;
        while (i < layerInfo.length) {
            LayerInfo li = this.layerInfo[i];
            layerInfo[i] = new LayerInfo(li.blockSize, (int)((float)li.hopSize * scale + 0.5f), li.analysisShrink, li.synthesisShrink * synthesisShrinkMult, li.enableEnergyCorrection);
            ++i;
        }
        SharpInfo result = new SharpInfo(this.knifeInfo, layerInfo);
        return result;
    }

    public SharpInfo copy(float synthesisShrinkMult) {
        LayerInfo[] layerInfo = new LayerInfo[this.layerInfo.length];
        int i = 0;
        while (i < layerInfo.length) {
            LayerInfo li = this.layerInfo[i];
            layerInfo[i] = new LayerInfo(li.blockSize, li.hopSize, li.analysisShrink, li.synthesisShrink * synthesisShrinkMult, li.enableEnergyCorrection);
            ++i;
        }
        SharpInfo result = new SharpInfo(this.knifeInfo, layerInfo);
        return result;
    }

    public SharpInfo multKnifeCopy(int mul, int div) {
        KnifeInfo[] knifeInfo = new KnifeInfo[this.knifeInfo.length];
        int i = 0;
        while (i < knifeInfo.length) {
            KnifeInfo ki = this.knifeInfo[i];
            knifeInfo[i] = new KnifeInfo(ki.blockSize * mul / div, ki.hopSize * mul / div, ki.minimizerLength, ki.averagerLength, ki.minSpan, ki.spread, ki.sensivityDb, ki.attackSpeedDb, ki.hard);
            ++i;
        }
        SharpInfo result = new SharpInfo(knifeInfo, this.layerInfo);
        return result;
    }

    private static int getFftSize(float resolution) {
        int fftSize = 2;
        while ((float)fftSize < resolution) {
            fftSize *= 2;
        }
        return fftSize;
    }

    public static int getHopSize(float resolution, float minOverlap) {
        int hopSize = 2;
        while ((float)hopSize <= resolution / minOverlap) {
            hopSize *= 2;
        }
        return hopSize / 2;
    }

    private static void checkValidity(LayerInfo ... infos) {
        if (infos.length <= 0) {
            throw new IllegalArgumentException();
        }
        int blockSize = infos[0].blockSize;
        int shiftSize = infos[0].hopSize;
        int i = 1;
        while (i < infos.length) {
            if (infos[i].blockSize != blockSize || infos[i].hopSize != shiftSize) {
                throw new IllegalArgumentException();
            }
            ++i;
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("{");
        int layer = 0;
        while (layer < this.nbLayers) {
            if (layer > 0) {
                result.append(" : ");
            }
            result.append(this.layerInfo[layer].toString());
            if (layer < this.knifeInfo.length) {
                result.append(" : ");
                result.append(this.knifeInfo[layer]);
            }
            ++layer;
        }
        result.append("}");
        return result.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.blockSize;
        result = 31 * result + this.hopSize;
        result = 31 * result + Arrays.hashCode(this.knifeInfo);
        result = 31 * result + Arrays.hashCode(this.layerInfo);
        result = 31 * result + this.nbLayers;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SharpInfo other = (SharpInfo)obj;
        if (this.blockSize != other.blockSize) {
            return false;
        }
        if (this.hopSize != other.hopSize) {
            return false;
        }
        if (!Arrays.equals(this.knifeInfo, other.knifeInfo)) {
            return false;
        }
        if (!Arrays.equals(this.layerInfo, other.layerInfo)) {
            return false;
        }
        return this.nbLayers == other.nbLayers;
    }
}

