/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.fourier;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.IFourierEngine;
import ch.tachyon.sonics.effect.base.fourier.ISpectrumProcessor;
import ch.tachyon.sonics.effect.utils.InOutResampler;
import ch.tachyon.sonics.effect.utils.buffer.Rebufferizer;
import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSectionManager;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.ArrayList;
import java.util.Arrays;
import org.corebounce.common.math.Cmplx;

public abstract class ResampledFourierEffectMtBase
extends EffectBase
implements IPushEffect,
IStartStop,
IBeginProcessing,
ILatency,
IHasSerialSections,
ISpectrumProcessor {
    private static final String PRE_SECTION_NAME = String.valueOf(ResampledFourierEffectMtBase.class.getName()) + "#pre";
    private static final String BUFFER_SECTION_NAME = String.valueOf(ResampledFourierEffectMtBase.class.getName()) + "#buffer";
    private static final String ENGINE_SECTION_NAME = String.valueOf(ResampledFourierEffectMtBase.class.getName()) + "#engine";
    private static final String POST_SECTION_NAME = String.valueOf(ResampledFourierEffectMtBase.class.getName()) + "#post";
    private IFourierEngine engine;
    private FourierSpec specs;
    private double resampleRatio;
    private InOutResampler preResampler;
    private Rebufferizer rebufferizer;
    private InOutResampler postResampler;
    private int remainingSamples;
    private ISerialSection preSection;
    private ISerialSection bufferSection;
    private ISerialSection engineSection;
    private ISerialSection postSection;

    protected ResampledFourierEffectMtBase() {
    }

    protected abstract FourierSpec getSpecs(IProcessingInfo var1);

    protected abstract double getResampleRatio(IProcessingInfo var1, FourierSpec var2);

    protected int getNbScales() {
        return this.engine != null ? this.engine.getNbScales() : this.specs.getNbLayers();
    }

    protected final int getNbResolutions() {
        return this.engine.getNbResolutions();
    }

    protected final int getNumHops(int scale) {
        return this.engine.getNumHops(scale);
    }

    public void startProcessing(IProcessingInfo info) {
        this.remainingSamples = 0;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        IProcessingInfo info = factory.getProcessingInfo();
        this.specs = this.getSpecs(info);
        this.specs.setMultihop(false);
        this.resampleRatio = this.getResampleRatio(info, this.specs);
        this.engine = this.specs.getProcessingType().createEngine();
        this.engine.setSpecs(this.specs);
        this.engine.startProcessing(info);
        DummySerialSectionManager manager = new DummySerialSectionManager(info);
        this.engine.createSerialSections(manager);
        this.preResampler = new InOutResampler(this.resampleRatio, 3, info.getMaxChunkLength(this.specs.getBaseResolution()));
        this.rebufferizer = new Rebufferizer(this.preResampler.getMaxOutputLength(), this.specs.getInputHopSize());
        this.postResampler = new InOutResampler(1.0 / this.resampleRatio, 3, this.preResampler.getMaxOutputLength());
        this.preSection = factory.createSerialSection(PRE_SECTION_NAME, this.preResampler);
        this.bufferSection = factory.createSerialSection(BUFFER_SECTION_NAME, this.rebufferizer);
        this.engineSection = factory.createSerialSection(ENGINE_SECTION_NAME, this.engine);
        this.postSection = factory.createSerialSection(POST_SECTION_NAME, this.postResampler);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.getSpecs(pool.getProcessingInfo());
        this.preSection = pool.getSerialSection(PRE_SECTION_NAME);
        this.bufferSection = pool.getSerialSection(BUFFER_SECTION_NAME);
        this.engineSection = pool.getSerialSection(ENGINE_SECTION_NAME);
        this.postSection = pool.getSerialSection(POST_SECTION_NAME);
        this.preResampler = this.preSection.getUserData(InOutResampler.class);
        this.rebufferizer = this.bufferSection.getUserData(Rebufferizer.class);
        this.engine = this.engineSection.getUserData(IFourierEngine.class);
        this.postResampler = this.postSection.getUserData(InOutResampler.class);
    }

    public int getLatency(IoDirection ioDirection) {
        return (int)((double)(this.engine.getLatency() + this.rebufferizer.getLatency()) / this.resampleRatio + 0.5);
    }

    public boolean canWriteFasterThanRead() {
        return false;
    }

    public void beginProcessing(IProcessingInfo info) {
        this.engine.beginProcessing(info);
    }

    public void process(float[] input, int length, ISingleChanAudioSink target) {
        this.remainingSamples += length;
        float[] output = this.processImpl(input);
        target.writeSamples(output);
        this.remainingSamples -= output.length;
        if (length < input.length) {
            this.preSection = new DummySerialSection();
            this.bufferSection = new DummySerialSection();
            this.engineSection = new DummySerialSection();
            this.postSection = new DummySerialSection();
            Arrays.fill(input, 0.0f);
            while (this.remainingSamples > 0) {
                output = this.processImpl(input);
                if (output.length > this.remainingSamples) {
                    float[] tail = new float[this.remainingSamples];
                    System.arraycopy(output, 0, tail, 0, this.remainingSamples);
                    output = tail;
                }
                target.writeSamples(output);
                this.remainingSamples -= output.length;
            }
        }
    }

    private float[] processImpl(float[] input) {
        this.preSection.enterSerialSection();
        float[] resampled = this.preResampler.resample(input, false);
        this.preSection.leaveSerialSection();
        this.bufferSection.enterSerialSection();
        this.rebufferizer.submitVariable(resampled);
        ArrayList<float[]> fixedBuffers = new ArrayList<float[]>();
        float[] fixed = this.rebufferizer.retrieveFixed();
        while (fixed != null) {
            float[] toEnqueue = new float[fixed.length];
            System.arraycopy(fixed, 0, toEnqueue, 0, fixed.length);
            fixedBuffers.add(toEnqueue);
            fixed = this.rebufferizer.retrieveFixed();
        }
        this.bufferSection.leaveSerialSection();
        this.engineSection.enterSerialSection();
        for (float[] buffer : fixedBuffers) {
            this.engine.process(buffer, this);
        }
        this.engineSection.leaveSerialSection();
        this.postSection.enterSerialSection();
        for (float[] buffer : fixedBuffers) {
            this.rebufferizer.submitFixed(buffer);
        }
        this.rebufferizer.retrieveVariable(resampled);
        float[] result = this.postResampler.resample(resampled, false);
        this.postSection.leaveSerialSection();
        return result;
    }

    public int getNumSteps() {
        return 1;
    }

    public abstract void process(int var1, int var2, Cmplx[] var3, Cmplx[] var4, int var5, long var6);

    protected final int getNbBins() {
        return this.engine.getNbBins();
    }

    protected final int getNbBins(int res) {
        return this.engine.getNbBins(res);
    }

    protected final int getInputHopSize() {
        return this.specs.getInputHopSize();
    }

    protected final int getDistanceBetweenFrames(int res) {
        return this.engine.getDistanceBetweenFrames(res);
    }

    public void stopProcessing() {
        this.engine.stopProcessing();
        this.preResampler.dispose();
        this.postResampler.dispose();
        this.engine = null;
        this.preResampler = null;
        this.rebufferizer = null;
        this.postResampler = null;
        this.specs = null;
    }

    static class DummyMtContext
    implements IMtContext {
        DummyMtContext() {
        }

        public int getMaxNbThreads() {
            return 1;
        }

        public boolean isMultiCore() {
            return false;
        }

        public void setNbThreads(int nbThreads) throws IllegalStateException {
            throw new IllegalStateException();
        }

        public int getSerialRunningMaxSkew() {
            return 1;
        }

        public int getSerialTotalMaxSkew() {
            return 1;
        }
    }
}

