/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.fourier.stretch;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.adaptive.Fork;
import ch.tachyon.sonics.effect.base.adaptive.SharpInfo;
import ch.tachyon.sonics.effect.base.fourier.FourierProcessingType;
import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.stretch.IFourierStretchEngine;
import ch.tachyon.sonics.effect.base.fourier.stretch.ISpectrumStretchProcessor;
import ch.tachyon.sonics.effect.base.fourier.stretch.StretchOptions;
import ch.tachyon.sonics.effect.base.pyramid.PyramidFourierStretchEngine;
import ch.tachyon.sonics.effect.base.stft.stretch.StftFourierStretchEngine;
import ch.tachyon.sonics.effect.utils.buffer.VarySpeedArrayBuffer;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IMultiChanPullEffect;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSectionManager;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.BitSet;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.MultiChanAudioSourceFork;

public abstract class FourierStretchEffectBase
extends EffectBase
implements IMultiChanPullEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections,
ISpectrumStretchProcessor {
    private FourierSpec specs;
    private StretchOptions options;
    private double stretchRatio;
    private float[][] forkInput;
    private Fork fork;
    private VarySpeedArrayBuffer[][] transienceBuffers;
    private float[][][][] edgeRatios;
    private IFourierStretchEngine engine;
    private double nbForkSteps;
    private double curForkStep;
    private int amSubSampleFactor;
    private int nbChans;
    private MultiChanAudioSourceFork sourceFork;

    protected abstract FourierSpec getSpecs(IProcessingInfo var1);

    protected abstract double getStretchRatio(IProcessingInfo var1);

    protected StretchOptions getOptions() {
        return this.options;
    }

    protected void setOptions(StretchOptions options) {
        this.options = options;
    }

    protected int getNbScales() {
        return this.engine != null ? this.engine.getNbScales() : this.specs.getNbScales();
    }

    protected final int getNbResolutions() {
        return this.engine.getNbResolutions();
    }

    protected final int getCurrentInputHopSize() {
        return this.engine.getCurrentInputHopSize();
    }

    public void startProcessing(IProcessingInfo info) {
        this.specs = this.getSpecs(info);
        this.stretchRatio = this.getStretchRatio(info);
        this.nbChans = info.getNumberOfChannels();
        if (this.options.nbLayers > 1) {
            int blockSize = this.specs.getBaseResolution();
            int overlap = this.specs.getIntOverlap();
            SharpInfo sharpInfo = new SharpInfo(blockSize, 3, 4.0f, blockSize, (float)overlap, info.getSampleRate());
            this.fork = new Fork(this.nbChans, sharpInfo);
        }
        if (this.specs.getProcessingType() == FourierProcessingType.SIMPLE) {
            this.engine = new StftFourierStretchEngine(this.stretchRatio, this.options, this.fork);
        } else if (this.specs.getProcessingType() == FourierProcessingType.PYRAMIDAL) {
            this.engine = new PyramidFourierStretchEngine(this.stretchRatio, this.options, this.fork);
        }
        this.engine.setSpecs(this.specs);
        this.engine.startProcessing(info);
    }

    public final int getFixedChunkLength() {
        return this.engine.getFixedChunkLength();
    }

    public int getLatency(IoDirection ioDirection) {
        int result = this.engine.getLatency();
        if (ioDirection == IoDirection.INPUT) {
            result = (int)((double)result / this.stretchRatio + 0.5);
        }
        return result;
    }

    public void beginProcessing(IProcessingInfo info) {
        int nbChans = info.getNumberOfChannels();
        if (this.fork != null) {
            DummySerialSectionManager ssManager = new DummySerialSectionManager(info);
            this.fork.createSerialSections(ssManager);
            this.fork.setSerialSections(ssManager);
            this.fork.init();
        }
        this.engine.beginProcessing(info);
        int engineInputSize = this.engine.getFixedChunkLength();
        int amDemodHopSize = this.engine.getAmDemodHopSize(0);
        assert (engineInputSize % amDemodHopSize == 0);
        this.curForkStep = 0.5;
        this.amSubSampleFactor = engineInputSize / amDemodHopSize;
        if (this.fork != null) {
            int forkInputSize = this.fork.getInputSize();
            this.forkInput = new float[nbChans][forkInputSize];
            this.nbForkSteps = (double)engineInputSize / (double)forkInputSize / this.stretchRatio;
            this.transienceBuffers = new VarySpeedArrayBuffer[this.fork.getNbKnifes()][nbChans];
            this.edgeRatios = new float[this.fork.getNbKnifes()][nbChans][][];
            int k = 0;
            while (k < this.fork.getNbKnifes()) {
                double speedChange = 1.0 / (this.nbForkSteps * (double)this.fork.getNumHops(k));
                speedChange *= (double)this.amSubSampleFactor;
                int capacity = this.fork.getNumHops(k) * (int)(this.nbForkSteps * (double)this.amSubSampleFactor + 1.0) + 1;
                int chan = 0;
                while (chan < nbChans) {
                    this.transienceBuffers[k][chan] = new VarySpeedArrayBuffer(speedChange, this.fork.getNbBins(k), capacity, 1);
                    this.edgeRatios[k][chan] = new float[this.amSubSampleFactor][this.fork.getNbBins(k)];
                    ++chan;
                }
                ++k;
            }
        }
    }

    public boolean canWriteFasterThanRead() {
        return this.stretchRatio > 1.0;
    }

    public int process(IMultiChanAudioSource source, float[][] output) {
        if (this.fork != null) {
            if (this.sourceFork == null) {
                this.sourceFork = new MultiChanAudioSourceFork(source, 2, this.nbChans);
            }
            this.curForkStep += this.nbForkSteps;
            while (this.curForkStep > 0.0) {
                IMultiChanAudioSource forkSource = this.sourceFork.getSource(0);
                forkSource.readSamples(this.forkInput);
                this.fork.process(this.forkInput);
                this.curForkStep -= 1.0;
                int k = 0;
                while (k < this.fork.getNbKnifes()) {
                    int chan = 0;
                    while (chan < this.nbChans) {
                        float[][] edgeRatios = new float[this.fork.getNumHops(k)][this.fork.getNbBins(k)];
                        this.fork.fillEdgeRatios(k, chan, edgeRatios);
                        this.transienceBuffers[k][chan].push(edgeRatios);
                        ++chan;
                    }
                    ++k;
                }
            }
            int k = 0;
            while (k < this.fork.getNbKnifes()) {
                int chan = 0;
                while (chan < this.nbChans) {
                    this.transienceBuffers[k][chan].pop(this.edgeRatios[k][chan]);
                    ++chan;
                }
                ++k;
            }
            return this.engine.process(this.sourceFork.getSource(1), this.edgeRatios, this, output);
        }
        return this.engine.process(source, null, this, output);
    }

    public abstract void process(int var1, Cmplx[] var2, Cmplx[][] var3, BitSet var4, BitSet var5);

    public void stopProcessing() {
        this.engine.stopProcessing();
        this.engine = null;
        this.fork = null;
        this.forkInput = null;
        this.sourceFork = null;
        this.specs = null;
        this.transienceBuffers = null;
        this.edgeRatios = null;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.engine.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.engine.setSerialSections(pool);
    }
}

