/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft;

import ch.tachyon.sonics.effect.base.stft.StftBufferArr;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.plugin.opt.thread.DummySerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSection;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class StftAnalyzer
implements IHasSerialSections {
    private static final String SECTION_NAME = "ch.tachyon.sonics.stft.analyzer";
    private final int blockSize;
    private final int hopSize;
    private final int numHops;
    private final int overlap;
    private int numHistoryBuffers;
    private final boolean copyMode;
    private StftBufferArr inBuffers;
    private final float[] analysisWindow;
    private BooFFT fft;
    private Cmplx[][] spectrums;
    private float[] processBuffer;
    private String name;
    private ISerialSection ss = new DummySerialSection();

    public StftAnalyzer(int blockSize, int overlap) {
        this(blockSize, blockSize / overlap, 1, StftAnalyzer.getDefaultWindow(blockSize), true);
    }

    private static float[] getDefaultWindow(int blockSize) {
        float[] window = new float[blockSize];
        Windows.fillWindow(window, Windows.HannCoefs);
        return window;
    }

    public StftAnalyzer(int blockSize0, int hopSize, int numHops, float[] analysisWindow, boolean copyMode) {
        int blockSize;
        this.blockSize = blockSize = AudioMath.getCeilingPowerOf2(blockSize0);
        this.hopSize = hopSize;
        this.numHops = numHops;
        this.overlap = (blockSize + hopSize - 1) / hopSize;
        this.numHistoryBuffers = 1 + (this.overlap + numHops - 1) / numHops;
        if (analysisWindow == null) {
            analysisWindow = WindowsFactory.getHannWindow(blockSize0, blockSize);
        }
        if (analysisWindow.length != blockSize) {
            throw new IllegalArgumentException("Length of analysis window must be AudioMath.getCeilingPowerOf2 of block size");
        }
        this.analysisWindow = analysisWindow;
        this.copyMode = copyMode;
    }

    public void init() {
        this.init(null);
    }

    public void init(StftAnalyzer other) {
        this.fft = other != null && other.getBlockSize() == this.blockSize ? other.getFFT() : new BooFFT(this.blockSize / 2);
        int nbBins = this.blockSize / 2 + 1;
        this.spectrums = Cmplx.newArray(this.numHops, nbBins);
        this.processBuffer = new float[this.blockSize];
        if (this.inBuffers == null) {
            assert (this.ss instanceof DummySerialSection);
            this.inBuffers = new StftBufferArr(this.hopSize * this.numHops, this.numHistoryBuffers, this.copyMode);
        }
    }

    BooFFT getFFT() {
        return this.fft;
    }

    public Cmplx[][] analyze(float[] input) {
        if (input.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size " + input.length + ". Must match hopSize * numHops " + this.hopSize * this.numHops);
        }
        int baseIndex = this.pushInput(input, this.ss.getClock());
        this.ss.sync();
        return this.analyzePushedInput(baseIndex);
    }

    public int pushInput(float[] input, long clock) {
        if (input.length != this.hopSize * this.numHops) {
            throw new IllegalArgumentException("Invalid size " + input.length + ". Must match hopSize * numHops " + this.hopSize * this.numHops);
        }
        int index = (int)(clock % (long)this.numHistoryBuffers);
        if (this.copyMode) {
            System.arraycopy(input, 0, this.inBuffers.buffers[index], 0, input.length);
        } else {
            this.inBuffers.buffers[index] = input;
        }
        return index;
    }

    public Cmplx[][] analyzePushedInput(int baseIndex) {
        int hopIndex = 0;
        while (hopIndex < this.numHops) {
            this.fetchInputBlock(baseIndex, hopIndex);
            this.applyAnalysisWindow();
            this.forwardFFT(this.spectrums[hopIndex]);
            ++hopIndex;
        }
        return this.spectrums;
    }

    public Cmplx[][] getSpectrums() {
        return this.spectrums;
    }

    private void fetchInputBlock(int baseIndex, int hopIndex) {
        int backwardOffset = this.overlap - 1 - hopIndex;
        baseIndex = (baseIndex + this.numHistoryBuffers - (backwardOffset + this.numHops - 1) / this.numHops) % this.numHistoryBuffers;
        int offset = (this.numHops - backwardOffset % this.numHops) % this.numHops * this.hopSize;
        int dst = 0;
        int k = 0;
        while (k < this.overlap) {
            int i;
            float[] historyBuffer = this.inBuffers.buffers[baseIndex];
            if (historyBuffer != null) {
                i = 0;
                while (i < this.hopSize) {
                    this.processBuffer[dst++] = historyBuffer[i + offset];
                    ++i;
                }
            } else {
                i = 0;
                while (i < this.hopSize) {
                    this.processBuffer[dst++] = 0.0f;
                    ++i;
                }
            }
            if ((offset += this.hopSize) >= this.hopSize * this.numHops) {
                baseIndex = (baseIndex + 1) % this.numHistoryBuffers;
                offset = 0;
            }
            ++k;
        }
    }

    private void applyAnalysisWindow() {
        int i = 0;
        while (i < this.blockSize) {
            int n = i;
            this.processBuffer[n] = this.processBuffer[n] * this.analysisWindow[i];
            ++i;
        }
    }

    private void forwardFFT(Cmplx[] spectrum) {
        this.fft.forwR2C(this.processBuffer, spectrum);
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getHopSize() {
        return this.hopSize;
    }

    public long getClock() {
        return this.ss.getClock();
    }

    public int getNumHops() {
        return this.numHops;
    }

    public int getInputSize() {
        return this.hopSize * this.numHops;
    }

    public int getOverlap() {
        return this.overlap;
    }

    public int getNbBins() {
        return this.blockSize / 2 + 1;
    }

    public int getAnalysisLatency() {
        return this.blockSize / 2 - this.hopSize;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private String sectionName() {
        if (this.name == null) {
            return SECTION_NAME;
        }
        return "ch.tachyon.sonics.stft.analyzer " + this.name;
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        assert (this.inBuffers == null);
        this.numHistoryBuffers = factory.getMtContext().getSerialRunningMaxSkew() + (this.overlap + this.numHops - 1) / this.numHops;
        this.inBuffers = new StftBufferArr(this.hopSize * this.numHops, this.numHistoryBuffers, this.copyMode);
        this.ss = factory.createSerialSection(this.sectionName(), this.inBuffers);
        factory.ensureMinInputHistorySize(this.overlap);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.numHistoryBuffers = pool.getMtContext().getSerialRunningMaxSkew() + (this.overlap + this.numHops - 1) / this.numHops;
        this.ss = pool.getSerialSection(this.sectionName());
        this.inBuffers = (StftBufferArr)this.ss.getUserData();
    }
}

