/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft;

import ch.tachyon.sonics.effect.base.stft.WindowSpec;
import java.util.Map;
import java.util.WeakHashMap;
import org.corebounce.common.dsp.fft.Windows;

public class WindowsFactory {
    private static final Map<WindowSpec, float[]> cache = new WeakHashMap<WindowSpec, float[]>();

    public static float[] getHannWindow(int size) {
        return WindowsFactory.getHannWindow(size, 1.0f);
    }

    public static float[] getHannWindow(int supportSize, int blockSize) {
        if (supportSize > blockSize) {
            throw new IllegalArgumentException();
        }
        float shrink = (float)blockSize / (float)supportSize;
        return WindowsFactory.getHannWindow(blockSize, shrink);
    }

    public static float[] getHannWindow(int size, float shrink) {
        return WindowsFactory.getHannWindow(size, shrink, true);
    }

    public static synchronized float[] getHannWindow(int size, float shrink, boolean energyCorrection) {
        WindowSpec spec = new WindowSpec(size, shrink, energyCorrection);
        float[] result = cache.get(spec);
        if (result == null) {
            result = new float[size];
            Windows.fillShrunkWindow(result, Windows.HannCoefs, shrink, energyCorrection);
            cache.put(spec, result);
        }
        return result;
    }
}

