/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.old;

import ch.tachyon.sonics.effect.EffectBase;
import ch.tachyon.sonics.effect.base.stft.StftAnalyzer;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizer;
import ch.tachyon.sonics.effect.base.stft.WindowsFactory;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.callback.IBeginProcessing;
import ch.tachyon.tunnel.plugin.opt.callback.IStartStop;
import ch.tachyon.tunnel.plugin.opt.spec.IFixedChunkLength;
import ch.tachyon.tunnel.plugin.opt.spec.ILatency;
import ch.tachyon.tunnel.plugin.opt.thread.IHasSerialSections;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.Arrays;
import org.corebounce.common.math.Cmplx;

public abstract class StftSimpleEffectBase
extends EffectBase
implements ISimpleEffect,
IStartStop,
IBeginProcessing,
IFixedChunkLength,
ILatency,
IHasSerialSections {
    private int blockSizeLog = 10;
    private int overlapLog = 3;
    private float[] analysisWindow;
    private float[] synthesisWindow;
    private StftAnalyzer analyzer;
    private StftSynthesizer synthesizer;

    protected StftSimpleEffectBase() {
    }

    protected StftSimpleEffectBase(int blockSizeLog, int overlapLog) {
        this.blockSizeLog = blockSizeLog;
        this.overlapLog = overlapLog;
    }

    protected int getBlockSizeLog() {
        return this.blockSizeLog;
    }

    protected void setBlockSizeLog(int blockSizeLog) {
        this.blockSizeLog = blockSizeLog;
    }

    protected int getOverlapLog() {
        return this.overlapLog;
    }

    protected void setOverlapLog(int overlapLog) {
        this.overlapLog = overlapLog;
    }

    protected float[] getAnalysisWindow() {
        return this.analysisWindow;
    }

    protected void setAnalysisWindow(float[] analysisWindow) {
        this.analysisWindow = analysisWindow;
    }

    protected float[] getSynthesisWindow() {
        return this.synthesisWindow;
    }

    protected void setSynthesisWindow(float[] synthesisWindow) {
        this.synthesisWindow = synthesisWindow;
    }

    public void startProcessing(IProcessingInfo info) {
        int blockSize = 1 << this.getBlockSizeLog();
        int overlap = 1 << this.getOverlapLog();
        if (this.analysisWindow == null) {
            this.analysisWindow = WindowsFactory.getHannWindow(blockSize);
        }
        if (this.synthesisWindow == null) {
            if (this.overlapLog <= 1) {
                this.synthesisWindow = new float[blockSize];
                Arrays.fill(this.synthesisWindow, 1.0f);
            } else {
                this.synthesisWindow = WindowsFactory.getHannWindow(blockSize);
            }
        }
        int hopSize = blockSize / overlap;
        int numHops = 1;
        int chunkLength = info.getHostPreferredChunkLength();
        if (chunkLength > 0 && (numHops = chunkLength / hopSize) < 1) {
            numHops = 1;
        }
        info.negociateFixedChunkLength(hopSize * numHops);
        this.analyzer = new StftAnalyzer(blockSize, hopSize, numHops, this.analysisWindow, true);
        this.synthesizer = new StftSynthesizer(blockSize, hopSize, numHops, this.analysisWindow, this.synthesisWindow);
    }

    public int getFixedChunkLength() {
        return this.analyzer.getInputSize();
    }

    public int getLatency(IoDirection ioDirection) {
        return this.synthesizer.getLatency();
    }

    public void beginProcessing(IProcessingInfo info) {
        this.analyzer.init();
        this.synthesizer.init(this.analyzer);
    }

    public void process(float[] data) {
        Cmplx[][] spectrums;
        Cmplx[][] cmplxArray = spectrums = this.analyzer.analyze(data);
        int n = spectrums.length;
        int n2 = 0;
        while (n2 < n) {
            Cmplx[] spectrum = cmplxArray[n2];
            this.processSpectrum(spectrum);
            ++n2;
        }
        this.synthesizer.synthesize(spectrums, data);
    }

    protected abstract void processSpectrum(Cmplx[] var1);

    public void stopProcessing() {
        this.analyzer = null;
        this.synthesizer = null;
    }

    protected final int getBlockSize() {
        return this.analyzer.getBlockSize();
    }

    protected final int getNbBins() {
        return this.analyzer.getNbBins();
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        this.analyzer.createSerialSections(factory);
        this.synthesizer.createSerialSections(factory);
    }

    public void setSerialSections(ISerialSectionPool pool) {
        this.analyzer.setSerialSections(pool);
        this.synthesizer.setSerialSections(pool);
    }
}

