/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.base.stft.stretch;

import ch.tachyon.sonics.effect.base.stft.StftAnalyzer;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizer;
import ch.tachyon.sonics.effect.base.stft.stretch.StftStretchAnalyzer;
import ch.tachyon.sonics.effect.utils.buffer.Bufferizer2;
import ch.tachyon.sonics.effect.utils.buffer.CmplxDelayBuffer;
import ch.tachyon.sonics.effect.utils.buffer.DelayBuffer;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionFactory;
import ch.tachyon.tunnel.plugin.opt.thread.ISerialSectionPool;
import java.util.BitSet;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.FastMath;

public class AmDemodEngine {
    private final int nbChans;
    private final double bsRatio;
    private final boolean fullCorrection;
    private final float strength;
    private final int numSteps;
    private final boolean antiLeakage;
    private Cmplx[][][] amDelayeds;
    private Bufferizer2.Stepper2 srcStepper;
    private Bufferizer2 inBufferizer;
    private float[][] data;
    private StftStretchAnalyzer amSrcAnalyser;
    private StftStretchAnalyzer antiLeakageAnalyzer;
    private CmplxDelayBuffer[] amSpectrumDelayers;
    private DelayBuffer[] amTimeDelayers;
    private StftAnalyzer[] amAnalysers;
    private StftSynthesizer[] amSynthesizers;
    private Bufferizer2 outBufferizer;

    public AmDemodEngine(int nbChans, int blockSize, int overlap, int outerOutputHopSize, double outerInputHopSize, int innerLatency, double bsRatio, double stretchRatio, boolean fullCorrection, float strength) {
        this(nbChans, blockSize, overlap, outerOutputHopSize, outerInputHopSize, innerLatency, bsRatio, stretchRatio, fullCorrection, strength, false);
    }

    public AmDemodEngine(int nbChans, int blockSize, int overlap, int outerOutputHopSize, double outerInputHopSize, int innerLatency, double bsRatio, double stretchRatio, boolean fullCorrection, float strength, boolean antiLeakage) {
        this.nbChans = nbChans;
        this.bsRatio = bsRatio;
        this.fullCorrection = fullCorrection;
        this.strength = strength;
        int innerOutputHopSize = blockSize / overlap;
        this.numSteps = Math.max(1, outerOutputHopSize / innerOutputHopSize);
        this.antiLeakage = antiLeakage;
        double innerInputHopSize = (double)innerOutputHopSize / stretchRatio;
        this.inBufferizer = new Bufferizer2(nbChans, outerOutputHopSize, innerOutputHopSize, true);
        this.srcStepper = new Bufferizer2.Stepper2(outerOutputHopSize, innerOutputHopSize, true);
        this.data = new float[nbChans][innerOutputHopSize];
        int nbBins = blockSize / 2 + 1;
        float[] window = new float[blockSize];
        Windows.fillWindow(window, Windows.HannCoefs);
        this.amSrcAnalyser = new StftStretchAnalyzer(nbChans, blockSize, innerInputHopSize, window);
        if (antiLeakage) {
            this.antiLeakageAnalyzer = new StftStretchAnalyzer(nbChans, blockSize, innerInputHopSize, window);
        }
        this.amAnalysers = new StftAnalyzer[nbChans];
        this.amSynthesizers = new StftSynthesizer[nbChans];
        int chan = 0;
        while (chan < nbChans) {
            this.amAnalysers[chan] = new StftAnalyzer(blockSize, innerOutputHopSize, 1, window, true);
            this.amAnalysers[chan].setName("am" + chan);
            this.amSynthesizers[chan] = new StftSynthesizer(blockSize, innerOutputHopSize, 1, window, window);
            this.amSynthesizers[chan].setName("am" + chan);
            ++chan;
        }
        this.amSpectrumDelayers = new CmplxDelayBuffer[nbChans];
        this.amTimeDelayers = new DelayBuffer[nbChans];
        int amAnalysisLatency = this.inBufferizer.getLatency() + this.amAnalysers[0].getAnalysisLatency();
        int fixLatency = 0;
        if (innerOutputHopSize != outerOutputHopSize) {
            fixLatency = (int)((double)(outerOutputHopSize - innerOutputHopSize) * (stretchRatio - 1.0) + 0.5);
        }
        int amDelay = innerLatency + amAnalysisLatency + fixLatency;
        int srcAnalyserLatency = (int)((double)this.amSrcAnalyser.getSrcOutputAnalysisLatency(innerOutputHopSize) * stretchRatio + 0.5);
        int amSpectrumDelay = ((amDelay -= srcAnalyserLatency) + innerOutputHopSize - 1) / innerOutputHopSize;
        if (amSpectrumDelay < 0) {
            amSpectrumDelay = 0;
        }
        int amTimeDelay = amSpectrumDelay * innerOutputHopSize - amDelay;
        assert (amTimeDelay >= 0);
        int chan2 = 0;
        while (chan2 < nbChans) {
            this.amSpectrumDelayers[chan2] = new CmplxDelayBuffer(amSpectrumDelay, nbBins);
            this.amTimeDelayers[chan2] = new DelayBuffer(amTimeDelay);
            ++chan2;
        }
        this.amDelayeds = Cmplx.newArray(this.numSteps, nbChans, nbBins);
        this.outBufferizer = new Bufferizer2(nbChans, innerOutputHopSize, outerOutputHopSize, false);
    }

    public int getLatency() {
        return this.inBufferizer.getLatency() + this.amSynthesizers[0].getLatency() + this.amTimeDelayers[0].getSize();
    }

    public int getHopSize() {
        return this.amAnalysers[0].getHopSize();
    }

    public void init(IProcessingInfo info) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.amAnalysers[chan].init();
            this.amSynthesizers[chan].init();
            ++chan;
        }
    }

    public void analyse(IMultiChanAudioSource source, IMultiChanAudioSource antiLeakageSource) {
        assert (this.antiLeakage == (antiLeakageSource != null));
        assert (this.antiLeakage == (this.antiLeakageAnalyzer != null));
        this.srcStepper.submit();
        int nbOutputs = this.srcStepper.getNumOutputsAvailable();
        int k = 0;
        while (k < nbOutputs) {
            this.srcStepper.retrieve();
            Cmplx[][] amSpectrums = this.amSrcAnalyser.analyze(source);
            if (this.antiLeakage) {
                Cmplx[][] alSpectrums = this.antiLeakageAnalyzer.analyze(antiLeakageSource);
                int chan = 0;
                while (chan < this.nbChans) {
                    Cmplx[] srcFrame = amSpectrums[chan];
                    Cmplx[] alFrame = alSpectrums[chan];
                    assert (srcFrame.length == alFrame.length);
                    int i = 0;
                    while (i < srcFrame.length) {
                        float alMag;
                        float srcMag = srcFrame[i].magApprox();
                        if (srcMag > (alMag = alFrame[i].magApprox())) {
                            srcFrame[i].mul(alMag / srcMag);
                        }
                        ++i;
                    }
                    ++chan;
                }
            }
            int chan = 0;
            while (chan < this.nbChans) {
                Cmplx[] delayed = this.amSpectrumDelayers[chan].push(amSpectrums[chan]);
                Cmplx[] amDelayed = this.amDelayeds[k][chan];
                int i = 0;
                while (i < delayed.length) {
                    amDelayed[i].set(delayed[i]);
                    ++i;
                }
                ++chan;
            }
            ++k;
        }
    }

    public void demodulate(float[][] input, int startBin, int stopBin, BitSet noSkipBins, float[][][] levels) {
        startBin = (int)((double)startBin * this.bsRatio + 0.5);
        stopBin = (int)((double)(stopBin - 1) * this.bsRatio + 0.5) + 1;
        this.inBufferizer.sumbit(input);
        int nbOutputs = this.inBufferizer.getNumOutputsAvailable();
        int levelFreqScaleDiv = 1;
        int levelFreqScaleMult = 1;
        if (levels != null) {
            assert (levels.length == this.nbChans);
            assert (levels[0].length == nbOutputs);
            int nbLevelBins = levels[0][0].length;
            int nbDataBins = this.amAnalysers[0].getNbBins();
            if (nbDataBins > nbLevelBins) {
                levelFreqScaleDiv = (nbDataBins - 1) / (nbLevelBins - 1);
            } else {
                levelFreqScaleMult = (nbLevelBins - 1) / (nbDataBins - 1);
            }
        }
        int k = 0;
        while (k < nbOutputs) {
            this.inBufferizer.retrieve(this.data);
            int chan = 0;
            while (chan < this.nbChans) {
                this.amTimeDelayers[chan].pushArray(this.data[chan]);
                Cmplx[][] synthHops = this.amAnalysers[chan].analyze(this.data[chan]);
                Cmplx[] synth = synthHops[0];
                Cmplx[] target = this.amDelayeds[k][chan];
                if (this.strength > 0.0f) {
                    int i = startBin;
                    while (i < stopBin) {
                        if (this.fullCorrection || noSkipBins.get(i)) {
                            float synthLevel = synth[i].magApprox();
                            float targetLevel = target[i].magApprox();
                            if (synthLevel > Float.MIN_NORMAL) {
                                float strength = this.strength;
                                if (levels != null) {
                                    float correction = levels[chan][k][i * levelFreqScaleMult / levelFreqScaleDiv];
                                    float f = strength = correction > 0.0f ? 1.0f : 0.0f;
                                }
                                if (strength == 1.0f) {
                                    synth[i].mul(targetLevel / synthLevel);
                                } else {
                                    float factor = targetLevel / synthLevel;
                                    if (!Float.isNaN(factor = (float)FastMath.pow(factor, strength)) && !Float.isInfinite(factor)) {
                                        synth[i].mul(factor);
                                    }
                                }
                            }
                        }
                        ++i;
                    }
                }
                this.amSynthesizers[chan].synthesize(synthHops, this.data[chan]);
                ++chan;
            }
            this.outBufferizer.sumbit(this.data);
            ++k;
        }
        assert (this.outBufferizer.getNumOutputsAvailable() >= 1);
        this.outBufferizer.retrieve(input);
    }

    public void createSerialSections(ISerialSectionFactory factory) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.amAnalysers[chan].createSerialSections(factory);
            this.amSynthesizers[chan].createSerialSections(factory);
            ++chan;
        }
    }

    public void setSerialSections(ISerialSectionPool pool) {
        int chan = 0;
        while (chan < this.nbChans) {
            this.amAnalysers[chan].setSerialSections(pool);
            this.amSynthesizers[chan].setSerialSections(pool);
            ++chan;
        }
    }
}

