/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.pitchtime;

import ch.tachyon.sonics.effect.base.fourier.FourierSpec;
import ch.tachyon.sonics.effect.base.fourier.stretch.FourierStretchEffectBase;
import ch.tachyon.sonics.effect.base.fourier.stretch.StretchOptions;
import ch.tachyon.sonics.effect.harmonic.FrequencyPeak;
import ch.tachyon.sonics.effect.harmonic.HarmonicSound;
import ch.tachyon.sonics.effect.harmonic.HarmonicSoundsDetector;
import ch.tachyon.sonics.effect.pitchtime.PhaseDelayAverager;
import ch.tachyon.sonics.effect.utils.MultiresolutionPeakPicker;
import ch.tachyon.sonics.effect.utils.PeakPicker;
import ch.tachyon.tunnel.plugin.IProcessingInfo;
import ch.tachyon.tunnel.plugin.opt.doc.Category;
import ch.tachyon.tunnel.plugin.opt.doc.Description;
import ch.tachyon.tunnel.plugin.opt.doc.Name;
import ch.tachyon.tunnel.plugin.param.Order;
import ch.tachyon.tunnel.plugin.param.PowerOfTwoTransform;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.Scale;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import ch.tachyon.tunnel.plugin.param.Transform;
import ch.tachyon.tunnel.utils.Debug;
import java.util.BitSet;
import java.util.List;
import java.util.Random;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.FastMath;

@Category(value="Tempo")
@Name(value="Time Stretch Vocoder")
@Description(value="Change the speed without affecting the pitch")
public class TimeStretchVocoder
extends FourierStretchEffectBase {
    private static final int[][] HSD_HIGHPASS_AND_COUNTS;
    private final double MIDDLE_FREQ_CUT = 1000.0;
    private double ratio;
    private int logBlockSize;
    private int blockSize;
    private int nbBins;
    private Mode mode = Mode.SCALED_LOCKING;
    private int logInputOverlap;
    private int logOutputOverlap;
    private int nbBands;
    private int logZeroPad;
    private boolean multiresolution;
    private int inputOverlap;
    private int outputOverlap;
    private PeakPicker peakPicker;
    private float[] powerMags;
    private double[] peakFrequencies;
    private double[] peakLevels;
    private int[] prevPeakBins;
    private int[] bounds;
    private int[] lockPeaks;
    private PhaseDelayAverager averager;
    private HarmonicSoundsDetector harmonicSoundsDetector;
    private float inHop;
    private float outHop;
    private double beta;
    private float[] phaseShifts0;
    private float[] phaseShifts;
    private float[] sourcePhases;
    private float[] prevSourcePhases;
    private Cmplx[] prevOutSource;
    private double[] frequencies;
    private double[] updatedPhases;
    private double[] unwrappedPhases;
    private BitSet silents;
    private Cmplx[] rotators;
    private int cycleCounter;
    private int resetCounter;
    private int outputOverlapCounter;
    private double[] prevDelays;

    static {
        int[][] nArrayArray = new int[1][];
        int[] nArray = new int[2];
        nArray[1] = 1;
        nArrayArray[0] = nArray;
        HSD_HIGHPASS_AND_COUNTS = nArrayArray;
    }

    @Order(value=1)
    @Scale(value=ScaleType.LOGARITHMIC)
    @Range(minValue=0.25, maxValue=4.0, defaultValue=1.0)
    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double ratio) {
        this.ratio = ratio;
    }

    @Order(value=2)
    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Name(value="Input Overlap")
    @Order(value=3)
    @Transform(value=PowerOfTwoTransform.class)
    @Range(minValue=1.0, maxValue=6.0, defaultValue=2.0)
    public int getLogInputOverlap() {
        return this.logInputOverlap;
    }

    public void setLogInputOverlap(int logOverlap) {
        this.logInputOverlap = logOverlap;
    }

    @Name(value="Output Overlap")
    @Order(value=4)
    @Transform(value=PowerOfTwoTransform.class)
    @Range(minValue=1.0, maxValue=6.0, defaultValue=2.0)
    public int getLogOutputOverlap() {
        return this.logOutputOverlap;
    }

    public void setLogOutputOverlap(int logOutputOverlap) {
        this.logOutputOverlap = logOutputOverlap;
    }

    @Order(value=5)
    @Range(minValue=1.0, maxValue=400.0, defaultValue=25.0)
    @Scale(value=ScaleType.LOGARITHMIC)
    public int getNbBands() {
        return this.nbBands;
    }

    public void setNbBands(int nbPeaks) {
        this.nbBands = nbPeaks;
    }

    @Order(value=6)
    @Transform(value=PowerOfTwoTransform.class)
    @Range(minValue=8.0, maxValue=17.0, defaultValue=12.0)
    @Name(value="Block Size")
    public int getLogBlockSize() {
        return this.logBlockSize;
    }

    public void setLogBlockSize(int logBlockSize) {
        this.logBlockSize = logBlockSize;
    }

    @Transform(value=PowerOfTwoTransform.class)
    @Range(minValue=0.0, maxValue=3.0, defaultValue=0.0)
    @Order(value=7)
    @Name(value="Zero pad")
    public int getLogZeroPad() {
        return this.logZeroPad;
    }

    public void setLogZeroPad(int logZeroPad) {
        this.logZeroPad = logZeroPad;
    }

    @Order(value=8)
    public boolean isMultiresolution() {
        return this.multiresolution;
    }

    public void setMultiresolution(boolean multiresolution) {
        this.multiresolution = multiresolution;
    }

    protected FourierSpec getSpecs(IProcessingInfo info) {
        float[] window;
        int inputOverlap = 1 << this.logInputOverlap;
        int outputOverlap = 1 << this.logOutputOverlap;
        int zeroPad = 1 << this.logZeroPad;
        FourierSpec specs = new FourierSpec(this.blockSize, inputOverlap);
        if (zeroPad > 1) {
            window = new float[this.blockSize];
            Windows.fillShrunkWindow(window, Windows.HannCoefs, zeroPad);
            specs.setAnalysisWindow(window);
        }
        if ((this.mode == Mode.N_PEAKS_LOCKING_IDENTITY || this.mode == Mode.N_PEAKS_LOCKING_SCALED) && outputOverlap > 2) {
            window = new float[this.blockSize];
            Windows.fillShrunkWindow(window, Windows.HannCoefs, (float)outputOverlap / 2.0f);
            specs.setSynthesisWindow(window);
        }
        return specs;
    }

    protected double getStretchRatio(IProcessingInfo info) {
        return this.ratio;
    }

    public void startProcessing(IProcessingInfo info) {
        int i;
        this.blockSize = 1 << this.logBlockSize;
        int zeroPad = 1 << this.logZeroPad;
        this.blockSize *= zeroPad;
        this.nbBins = this.blockSize / 2 + 1;
        this.outputOverlap = 1 << this.logOutputOverlap;
        this.inputOverlap = 1 << this.logInputOverlap;
        int skipCount = this.inputOverlap / this.outputOverlap;
        if (skipCount < 1) {
            skipCount = 1;
        }
        super.setOptions(new StretchOptions(skipCount, 1.0f, 1, false, 0.0f, 0.0f, false));
        super.startProcessing(info);
        if (this.mode.isPeakPicker()) {
            this.peakPicker = this.multiresolution ? new MultiresolutionPeakPicker(this.nbBins) : new PeakPicker(this.nbBins);
            this.powerMags = new float[this.nbBins];
            this.peakFrequencies = new double[this.peakPicker.getMaxNbPeaks()];
            this.peakLevels = new double[this.peakPicker.getMaxNbPeaks()];
            this.prevPeakBins = new int[this.nbBins];
            i = 0;
            while (i < this.nbBins) {
                this.prevPeakBins[i] = i;
                ++i;
            }
        }
        this.phaseShifts0 = new float[this.nbBins];
        this.phaseShifts = new float[this.nbBins];
        this.sourcePhases = new float[this.nbBins];
        this.prevSourcePhases = new float[this.nbBins];
        this.prevOutSource = Cmplx.newArray(this.nbBins);
        this.frequencies = new double[this.nbBins];
        this.updatedPhases = new double[this.nbBins];
        this.unwrappedPhases = new double[this.nbBins];
        this.silents = new BitSet(this.nbBins);
        this.rotators = Cmplx.newArray(this.nbBins);
        i = 0;
        while (i < this.nbBins) {
            this.rotators[i].set(1.0f, 0.0f);
            ++i;
        }
        this.cycleCounter = 0;
        this.resetCounter = 0;
        this.outputOverlapCounter = 0;
        if (this.peakPicker != null) {
            this.prevDelays = new double[this.peakPicker.getMaxNbPeaks()];
        }
        if (this.mode == Mode.VOCODER) {
            Random rnd = new Random();
            int i2 = 0;
            while (i2 < this.nbBins) {
                Cmplx pos = this.prevOutSource[i2];
                pos.set(1.0f, rnd.nextFloat() * (float)Math.PI * 2.0f);
                pos.toCartesianApprox();
                ++i2;
            }
        }
        this.bounds = new int[this.nbBands + 1];
        this.bounds[0] = 0;
        this.bounds[this.nbBands] = this.nbBins;
        double minInc = 4.0 * (double)this.nbBands / (double)this.nbBins;
        double logMin = Math.log(minInc);
        double logMax = Math.log(this.nbBands);
        double prevValue = 0.0;
        int band = 1;
        while (band < this.nbBands) {
            int binNum;
            double logValue = logMin + (logMax - logMin) / (double)(this.nbBands + 1 - band);
            double value = Math.exp(logValue);
            if (prevValue + minInc > value) {
                value = prevValue + minInc;
            }
            this.bounds[band] = binNum = (int)(value * (double)this.nbBins / (double)this.nbBands + 0.5);
            if (this.bounds[band] >= this.nbBins) {
                this.bounds[band] = this.nbBins;
                this.nbBands = band;
                Debug.warn("Using only {0} bands", this.nbBands);
                break;
            }
            logMin = Math.log(value);
            prevValue = value;
            ++band;
        }
        this.lockPeaks = new int[this.nbBands];
        if (this.mode.isComplexStuff()) {
            this.averager = new PhaseDelayAverager(this.blockSize, this.blockSize / 4, this.nbBins);
            this.harmonicSoundsDetector = new HarmonicSoundsDetector(this.blockSize, HSD_HIGHPASS_AND_COUNTS);
        }
        if (this.outputOverlap <= 2) {
            this.beta = 1.0;
        } else if (this.ratio < 1.0) {
            this.beta = 0.6666666666666666 + 0.3333333333333333 * this.ratio;
        } else if (this.ratio < 2.0) {
            double beta0 = 0.6666666666666666 + 0.3333333333333333 * this.ratio;
            this.beta = beta0 * (2.0 - this.ratio) + this.ratio * (this.ratio - 1.0);
        } else {
            this.beta = this.ratio;
        }
    }

    public void process(int scale, Cmplx[] source, Cmplx[][] spectrums, BitSet incoherent, BitSet noSkipFrames) {
        double phaseShift;
        double phaseDelay;
        double frequency;
        int middleBin;
        int peakNum;
        int skipCount = this.inputOverlap / this.outputOverlap;
        if (skipCount < 1) {
            skipCount = 1;
        }
        int nbChans = spectrums.length;
        this.normalize(source, spectrums);
        if ((this.mode == Mode.N_PEAKS_LOCKING_IDENTITY || this.mode == Mode.N_PEAKS_LOCKING_SCALED) && this.outputOverlap == 2) {
            incoherent.set(0, this.nbBins);
        } else {
            incoherent.clear(0, this.nbBins);
        }
        this.inHop = super.getCurrentInputHopSize();
        this.outHop = (float)this.blockSize / (float)this.inputOverlap;
        int nbPeaks = 0;
        if (this.mode.isPeakPicker()) {
            if (this.cycleCounter == 0) {
                PeakPicker.fillPowerMags(source, this.powerMags);
                this.peakPicker.pickPeaks(this.powerMags);
                this.peakPicker.fillPeakFrequencies(this.peakFrequencies);
                this.peakPicker.fillPeakPowerLevels(this.peakFrequencies, this.peakLevels);
            }
            nbPeaks = this.peakPicker.getNbPeaks();
        }
        int i = 0;
        while (i < this.nbBins) {
            this.sourcePhases[i] = source[i].phiApprox();
            ++i;
        }
        if (this.mode == Mode.VOCODER) {
            this.computePhaseShiftsAllBins(source);
            i = 0;
            while (i < this.nbBins) {
                this.calculatePhasePropagation(this.sourcePhases, i);
                ++i;
            }
            if (this.logZeroPad == 0) {
                int chan = 0;
                while (chan < nbChans) {
                    Cmplx[] spectrum = spectrums[chan];
                    int i2 = 0;
                    while (i2 < this.nbBins) {
                        spectrum[i2].mul(1.414f);
                        ++i2;
                    }
                    ++chan;
                }
            }
            this.applyPhasePropagation(source, spectrums);
        } else if (this.mode == Mode.LOOSE_LOCKING || this.mode == Mode.LOOSE_ROTATOR_LOCKING) {
            int i3;
            this.computePhaseShiftsAllBins(source);
            i = 0;
            while (i < this.nbBins) {
                this.calculatePhasePropagation(this.sourcePhases, i);
                ++i;
            }
            if (this.mode == Mode.LOOSE_ROTATOR_LOCKING) {
                Cmplx previous = new Cmplx();
                Cmplx locked = new Cmplx();
                previous.set(this.rotators[0]);
                i3 = 1;
                while (i3 < this.nbBins - 1) {
                    locked.set(0.0f, 0.0f);
                    locked.add(previous);
                    locked.add(this.rotators[i3 + 1]);
                    locked.add(this.rotators[i3]);
                    previous.set(this.rotators[i3]);
                    this.rotators[i3].set(locked);
                    float mag = this.rotators[i3].magApprox();
                    if (mag > Float.MIN_NORMAL) {
                        this.rotators[i3].mul(1.0f / mag);
                    } else {
                        this.rotators[i3].set(previous);
                    }
                    ++i3;
                }
            }
            this.applyPhasePropagation(source, spectrums);
            if (this.mode == Mode.LOOSE_LOCKING) {
                Cmplx sum = new Cmplx();
                Cmplx previous = new Cmplx();
                previous.set(this.prevOutSource[0]);
                i3 = 1;
                while (i3 < this.nbBins - 1) {
                    sum.set(this.prevOutSource[i3]);
                    sum.add(previous);
                    sum.add(this.prevOutSource[i3 + 1]);
                    previous.set(this.prevOutSource[i3]);
                    float phi = sum.phiApprox();
                    this.prevOutSource[i3].re = this.prevOutSource[i3].magApprox();
                    this.prevOutSource[i3].im = phi;
                    this.prevOutSource[i3].toCartesianApprox();
                    int chan = 0;
                    while (chan < nbChans) {
                        spectrums[chan][i3].re = spectrums[chan][i3].magApprox();
                        spectrums[chan][i3].im = phi;
                        spectrums[chan][i3].toCartesianApprox();
                        ++chan;
                    }
                    ++i3;
                }
            }
        } else if (this.mode == Mode.IDENTITY_LOCKING) {
            this.computePhaseShiftsAllPeaks(source);
            peakNum = 0;
            while (peakNum < nbPeaks) {
                int peakBin = this.peakPicker.getPeakBinIndex(peakNum);
                this.calculatePhasePropagation(this.sourcePhases, peakBin);
                int startBin = this.peakPicker.getPeakLowerBin(peakNum);
                int stopBin = this.peakPicker.getPeakUpperBin(peakNum);
                int i4 = startBin;
                while (i4 < stopBin) {
                    this.rotators[i4].set(this.rotators[peakBin]);
                    ++i4;
                }
                ++peakNum;
            }
            this.applyPhasePropagation(source, spectrums);
        } else if (this.mode == Mode.FOLLOWING_LOCKING || this.mode == Mode.SCALED_LOCKING || this.mode == Mode.PHAVORIT) {
            int peakIndex = 0;
            while (peakIndex < nbPeaks) {
                int curBinIndex = this.peakPicker.getPeakBinIndex(peakIndex);
                int prevBinIndex = this.prevPeakBins[curBinIndex];
                this.computePhaseShift(source, curBinIndex, prevBinIndex);
                ++peakIndex;
            }
            this.populatePhaseShiftsIfWorth();
            double threshold1 = AudioMath.dbToPowerLevel(-19.0);
            double threshold2 = AudioMath.dbToPowerLevel(-21.0);
            int peakNum2 = 0;
            while (peakNum2 < nbPeaks) {
                int peakBin = this.peakPicker.getPeakBinIndex(peakNum2);
                this.calculateUpdatedPhases(peakBin, this.prevPeakBins[peakBin]);
                if (this.mode == Mode.PHAVORIT) {
                    double powerMag = source[peakBin].powerMag();
                    if (this.silents.get(peakBin)) {
                        if (powerMag > threshold1) {
                            this.updatedPhases[peakBin] = this.sourcePhases[peakBin];
                            this.prevSourcePhases[peakBin] = 0.0f;
                            this.silents.clear(peakBin);
                        }
                    } else if (powerMag < threshold2) {
                        this.silents.set(peakBin);
                    }
                }
                int startBin = this.peakPicker.getPeakLowerBin(peakNum2);
                int stopBin = this.peakPicker.getPeakUpperBin(peakNum2);
                if (this.mode == Mode.FOLLOWING_LOCKING) {
                    double phaseRotation = this.updatedPhases[peakBin] - (double)this.sourcePhases[peakBin];
                    this.rotators[peakBin].set(1.0f, (float)phaseRotation);
                    this.rotators[peakBin].toCartesianApprox();
                    int i5 = startBin;
                    while (i5 < stopBin) {
                        this.rotators[i5].set(this.rotators[peakBin]);
                        this.prevPeakBins[i5] = peakBin;
                        ++i5;
                    }
                } else {
                    double unwrappedPhase;
                    this.unwrappedPhases[startBin] = unwrappedPhase = (double)this.sourcePhases[startBin];
                    double previousPhase = unwrappedPhase;
                    int i6 = startBin + 1;
                    while (i6 < stopBin) {
                        double currentPhase = this.sourcePhases[i6];
                        double phaseDiff = currentPhase - previousPhase;
                        if (phaseDiff > Math.PI) {
                            phaseDiff -= Math.PI * 2;
                        } else if (phaseDiff < -Math.PI) {
                            phaseDiff += Math.PI * 2;
                        }
                        this.unwrappedPhases[i6] = unwrappedPhase += phaseDiff;
                        previousPhase = currentPhase;
                        ++i6;
                    }
                    assert (peakBin >= startBin && peakBin <= stopBin);
                    i6 = startBin;
                    while (i6 < stopBin) {
                        double updatedPhase = this.updatedPhases[peakBin] + this.beta * (this.unwrappedPhases[i6] - this.unwrappedPhases[peakBin]);
                        double phaseRotation = updatedPhase - this.unwrappedPhases[i6];
                        this.rotators[i6].set(1.0f, (float)phaseRotation);
                        this.rotators[i6].toCartesianApprox();
                        this.prevPeakBins[i6] = peakBin;
                        ++i6;
                    }
                }
                ++peakNum2;
            }
            this.applyPhasePropagation(source, spectrums);
        } else if (this.mode == Mode.N_PEAKS_LOCKING_SCALED) {
            this.computePhaseShiftsAllPeaks(source);
            this.peakPicker.fillReverseArray();
            this.fillBandDominantPeaks();
            peakNum = 0;
            while (peakNum < nbPeaks) {
                int curBinNum = this.peakPicker.getPeakBinIndex(peakNum);
                int prevBinNum = this.prevPeakBins[curBinNum];
                this.calculatePhasePropagation(this.sourcePhases, curBinNum, prevBinNum);
                ++peakNum;
            }
            middleBin = (int)(1000.0 * (double)this.blockSize / 44100.0 + 0.5);
            int band = 0;
            while (band < this.nbBands) {
                int peakNum0 = this.lockPeaks[band];
                int binNum0 = this.peakPicker.getPeakBinIndex(peakNum0);
                double frequency0 = this.frequencies[binNum0];
                double period0 = frequency0 > 0.0 ? Math.PI * 2 / frequency0 : 1.0;
                double phaseShift0 = FastMath.wrap(this.updatedPhases[binNum0] - (double)this.sourcePhases[binNum0]);
                if (phaseShift0 < 0.0) {
                    phaseShift0 += Math.PI * 2;
                }
                double baseDelay0 = phaseShift0 * period0 / (Math.PI * 2);
                int i7 = this.bounds[band];
                while (i7 < this.bounds[band + 1]) {
                    int peakNum3 = this.peakPicker.findNearestPeakNum(i7);
                    if (i7 == this.peakPicker.getPeakBinIndex(peakNum3) && i7 > middleBin) {
                        frequency = this.frequencies[i7];
                        double period = frequency > 0.0 ? Math.PI * 2 / frequency : 1.0;
                        phaseDelay = baseDelay0 % period;
                        phaseShift = phaseDelay * (Math.PI * 2) / period;
                        this.updatedPhases[i7] = (double)this.sourcePhases[i7] + phaseShift;
                        this.rotators[i7].set(1.0f, (float)phaseShift);
                        this.rotators[i7].toCartesianApprox();
                    }
                    ++i7;
                }
                ++band;
            }
            int peakNum4 = 0;
            while (peakNum4 < nbPeaks) {
                double unwrappedPhase;
                int peakBin = this.peakPicker.getPeakBinIndex(peakNum4);
                int startBin = this.peakPicker.getPeakLowerBin(peakNum4);
                int stopBin = this.peakPicker.getPeakUpperBin(peakNum4);
                this.unwrappedPhases[startBin] = unwrappedPhase = (double)this.sourcePhases[startBin];
                double previousPhase = unwrappedPhase;
                int i8 = startBin + 1;
                while (i8 < stopBin) {
                    double currentPhase = this.sourcePhases[i8];
                    double phaseDiff = currentPhase - previousPhase;
                    if (phaseDiff > Math.PI) {
                        phaseDiff -= Math.PI * 2;
                    } else if (phaseDiff < -Math.PI) {
                        phaseDiff += Math.PI * 2;
                    }
                    this.unwrappedPhases[i8] = unwrappedPhase += phaseDiff;
                    previousPhase = currentPhase;
                    ++i8;
                }
                assert (peakBin >= startBin && peakBin <= stopBin);
                i8 = startBin;
                while (i8 < stopBin) {
                    double updatedPhase = this.updatedPhases[peakBin] + this.beta * (this.unwrappedPhases[i8] - this.unwrappedPhases[peakBin]);
                    double phaseRotation = updatedPhase - this.unwrappedPhases[i8];
                    this.rotators[i8].set(1.0f, (float)phaseRotation);
                    this.rotators[i8].toCartesianApprox();
                    this.prevPeakBins[i8] = peakBin;
                    ++i8;
                }
                ++peakNum4;
            }
            this.applyPhasePropagation(source, spectrums);
        } else if (this.mode == Mode.N_PEAKS_LOCKING_IDENTITY) {
            this.computePhaseShiftsAllPeaks(source);
            this.peakPicker.fillReverseArray();
            this.fillBandDominantPeaks();
            peakNum = 0;
            while (peakNum < nbPeaks) {
                int curBinNum = this.peakPicker.getPeakBinIndex(peakNum);
                int prevBinNum = this.prevPeakBins[curBinNum];
                this.calculatePhasePropagation(this.sourcePhases, curBinNum, prevBinNum);
                ++peakNum;
            }
            middleBin = (int)(1000.0 * (double)this.blockSize / 44100.0 + 0.5);
            int band = 0;
            while (band < this.nbBands) {
                int peakNum0 = this.lockPeaks[band];
                int binNum0 = this.peakPicker.getPeakBinIndex(peakNum0);
                double frequency0 = this.frequencies[binNum0];
                double period0 = frequency0 > 0.0 ? Math.PI * 2 / frequency0 : 1.0;
                double phaseShift0 = FastMath.wrap(this.updatedPhases[binNum0] - (double)this.sourcePhases[binNum0]);
                if (phaseShift0 < 0.0) {
                    phaseShift0 += Math.PI * 2;
                }
                double baseDelay0 = phaseShift0 * period0 / (Math.PI * 2);
                int i9 = this.bounds[band];
                while (i9 < this.bounds[band + 1]) {
                    int peakNum5 = this.peakPicker.findNearestPeakNum(i9);
                    if (i9 == this.peakPicker.getPeakBinIndex(peakNum5) && i9 > middleBin) {
                        frequency = this.frequencies[i9];
                        double period = frequency > 0.0 ? Math.PI * 2 / frequency : 1.0;
                        phaseDelay = baseDelay0 % period;
                        phaseShift = phaseDelay * (Math.PI * 2) / period;
                        this.updatedPhases[i9] = (double)this.sourcePhases[i9] + phaseShift;
                        this.rotators[i9].set(1.0f, (float)phaseShift);
                        this.rotators[i9].toCartesianApprox();
                    }
                    ++i9;
                }
                ++band;
            }
            int peakNum6 = 0;
            while (peakNum6 < nbPeaks) {
                int peakBin = this.peakPicker.getPeakBinIndex(peakNum6);
                int startBin = this.peakPicker.getPeakLowerBin(peakNum6);
                int stopBin = this.peakPicker.getPeakUpperBin(peakNum6);
                int i10 = startBin;
                while (i10 < stopBin) {
                    this.rotators[i10].set(this.rotators[peakBin]);
                    ++i10;
                }
                ++peakNum6;
            }
            this.applyPhasePropagation(source, spectrums);
        } else if (this.mode == Mode.N_PEAKS_AVG) {
            this.computePhaseShiftsAllPeaks(source);
            this.peakPicker.fillReverseArray();
            peakNum = 0;
            while (peakNum < nbPeaks) {
                int binNum = this.peakPicker.getPeakBinIndex(peakNum);
                this.calculateUpdatedPhases(binNum, binNum);
                ++peakNum;
            }
            int band = 0;
            while (band < this.nbBands) {
                this.averager.reset();
                int i11 = this.bounds[band];
                while (i11 < this.bounds[band + 1]) {
                    int peakNum7 = this.peakPicker.findNearestPeakNum(i11);
                    if (i11 == this.peakPicker.getPeakBinIndex(peakNum7)) {
                        double frequency2 = this.frequencies[i11];
                        double period = frequency2 > 0.0 ? Math.PI * 2 / frequency2 : 1.0;
                        double phaseShift2 = FastMath.wrap(this.updatedPhases[i11] - (double)this.sourcePhases[i11]);
                        if (phaseShift2 < 0.0) {
                            phaseShift2 += Math.PI * 2;
                        }
                        double baseDelay = phaseShift2 * period / (Math.PI * 2);
                        double weight = source[i11].magApprox();
                        this.averager.add(baseDelay, period, weight);
                    }
                    ++i11;
                }
                double averagePhaseDelay = this.averager.computeAverage();
                int i12 = this.bounds[band];
                while (i12 < this.bounds[band + 1]) {
                    int peakNum8 = this.peakPicker.findNearestPeakNum(i12);
                    if (i12 == this.peakPicker.getPeakBinIndex(peakNum8)) {
                        double frequency3 = this.frequencies[i12];
                        double period = frequency3 > 0.0 ? Math.PI * 2 / frequency3 : 1.0;
                        double phaseDelay2 = averagePhaseDelay % period;
                        double phaseShift3 = phaseDelay2 * (Math.PI * 2) / period;
                        this.updatedPhases[i12] = (double)this.sourcePhases[i12] + phaseShift3;
                        this.rotators[i12].set(1.0f, (float)phaseShift3);
                        this.rotators[i12].toCartesianApprox();
                    }
                    ++i12;
                }
                ++band;
            }
            peakNum = 0;
            while (peakNum < nbPeaks) {
                int peakBin = this.peakPicker.getPeakBinIndex(peakNum);
                int startBin = this.peakPicker.getPeakLowerBin(peakNum);
                int stopBin = this.peakPicker.getPeakUpperBin(peakNum);
                int i13 = startBin;
                while (i13 < stopBin) {
                    this.rotators[i13].set(this.rotators[peakBin]);
                    ++i13;
                }
                ++peakNum;
            }
            this.applyPhasePropagation(source, spectrums);
        } else if (this.mode == Mode.PIECEWISE_SHIFT) {
            int peakBin;
            this.computePhaseShiftsAllPeaks(source);
            this.peakPicker.fillReverseArray();
            peakNum = 0;
            while (peakNum < nbPeaks) {
                int binNum = this.peakPicker.getPeakBinIndex(peakNum);
                this.calculatePhasePropagation(this.sourcePhases, binNum);
                ++peakNum;
            }
            peakNum = 0;
            while (peakNum < nbPeaks) {
                peakBin = this.peakPicker.getPeakBinIndex(peakNum);
                double frequency4 = this.frequencies[peakBin];
                double period = frequency4 > 0.0 ? Math.PI * 2 / frequency4 : 1.0;
                double phaseShift4 = FastMath.wrap(this.updatedPhases[peakBin] - (double)this.sourcePhases[peakBin]);
                if (phaseShift4 < 0.0) {
                    phaseShift4 += Math.PI * 2;
                }
                double phaseDelay3 = phaseShift4 * period / (Math.PI * 2);
                double bestPhaseDelay = 0.0;
                double bestDelay = 0.0;
                double bestDiff = Double.POSITIVE_INFINITY;
                int k = 0;
                while (k < this.nbBands) {
                    double curDelay0 = (double)k / (double)this.nbBands;
                    curDelay0 = Math.pow(curDelay0, 1.1);
                    double curDelay = curDelay0 * (double)this.blockSize;
                    double curPhaseDelay = curDelay % period;
                    double diff = Math.abs(curPhaseDelay - phaseDelay3);
                    if (curDelay == this.prevDelays[peakNum]) {
                        diff /= 2.0;
                    }
                    if (diff < bestDiff) {
                        bestDiff = diff;
                        bestDelay = curDelay;
                        bestPhaseDelay = curPhaseDelay;
                    }
                    ++k;
                }
                this.prevDelays[peakNum] = bestDelay;
                phaseShift4 = bestPhaseDelay * (Math.PI * 2) / period;
                this.updatedPhases[peakBin] = (double)this.sourcePhases[peakBin] + phaseShift4;
                this.rotators[peakBin].set(1.0f, (float)phaseShift4);
                this.rotators[peakBin].toCartesianApprox();
                ++peakNum;
            }
            peakNum = 0;
            while (peakNum < nbPeaks) {
                peakBin = this.peakPicker.getPeakBinIndex(peakNum);
                int startBin = this.peakPicker.getPeakLowerBin(peakNum);
                int stopBin = this.peakPicker.getPeakUpperBin(peakNum);
                int i14 = startBin;
                while (i14 < stopBin) {
                    this.rotators[i14].set(this.rotators[peakBin]);
                    ++i14;
                }
                ++peakNum;
            }
            this.applyPhasePropagation(source, spectrums);
        } else if (this.mode == Mode.HARMONICS) {
            int peakBin;
            List sounds = this.harmonicSoundsDetector.detectHarmonicSounds(this.powerMags);
            this.computePhaseShiftsAllPeaks(source);
            this.averager.reset();
            BitSet harmonicPeaks = new BitSet();
            int firstK = 0;
            int peakNum9 = 0;
            while (peakNum9 < nbPeaks) {
                int peakBin2 = this.peakPicker.getPeakBinIndex(peakNum9);
                this.calculatePhasePropagation(this.sourcePhases, peakBin2);
                double frequency5 = this.frequencies[peakBin2];
                boolean isHarmonic = false;
                for (HarmonicSound sound : sounds) {
                    int k = 0;
                    for (FrequencyPeak freqPeak : sound.getHarmonics()) {
                        double hFreq;
                        if (freqPeak != null && this.distance(hFreq = freqPeak.getFrequency() * Math.PI * 2.0, frequency5) < 1.02) {
                            isHarmonic = true;
                            if (firstK <= 0) {
                                firstK = k;
                            }
                        }
                        ++k;
                    }
                }
                if (isHarmonic) {
                    harmonicPeaks.set(peakNum9);
                }
                ++peakNum9;
            }
            double lockPhaseDelay = 0.0;
            boolean isFirst = true;
            int peakNum10 = 0;
            while (peakNum10 < nbPeaks) {
                peakBin = this.peakPicker.getPeakBinIndex(peakNum10);
                if (harmonicPeaks.get(peakNum10)) {
                    if (isFirst) {
                        double frequency0 = this.frequencies[peakBin];
                        double period0 = frequency0 > 0.0 ? Math.PI * 2 / frequency0 : 1.0;
                        double phaseShift0 = FastMath.wrap(this.updatedPhases[peakBin] - (double)this.sourcePhases[peakBin]);
                        if (phaseShift0 < 0.0) {
                            phaseShift0 += Math.PI * 2;
                        }
                        lockPhaseDelay = phaseShift0 * period0 / (Math.PI * 2);
                        lockPhaseDelay *= (double)firstK;
                        isFirst = false;
                    } else {
                        double oldUpdatedPhase;
                        double frequency6 = this.frequencies[peakBin];
                        double period = frequency6 > 0.0 ? Math.PI * 2 / frequency6 : 1.0;
                        double phaseDelay4 = lockPhaseDelay % period;
                        double phaseShift5 = phaseDelay4 * (Math.PI * 2) / period;
                        double newUpdatedPhase = FastMath.wrap((double)this.sourcePhases[peakBin] + phaseShift5);
                        double deltaPhase = newUpdatedPhase - (oldUpdatedPhase = FastMath.wrap(this.updatedPhases[peakBin]));
                        if (deltaPhase > Math.PI) {
                            deltaPhase -= Math.PI * 2;
                        } else if (deltaPhase < -Math.PI) {
                            deltaPhase += Math.PI * 2;
                        }
                        int n = peakBin;
                        this.updatedPhases[n] = this.updatedPhases[n] + deltaPhase * 0.7;
                        double phaseRotation = this.updatedPhases[peakBin] - (double)this.sourcePhases[peakBin];
                        this.rotators[peakBin].set(1.0f, (float)phaseRotation);
                        this.rotators[peakBin].toCartesianApprox();
                    }
                }
                ++peakNum10;
            }
            peakNum10 = 0;
            while (peakNum10 < nbPeaks) {
                peakBin = this.peakPicker.getPeakBinIndex(peakNum10);
                int startBin = this.peakPicker.getPeakLowerBin(peakNum10);
                int stopBin = this.peakPicker.getPeakUpperBin(peakNum10);
                int i15 = startBin;
                while (i15 < stopBin) {
                    this.rotators[i15].set(this.rotators[peakBin]);
                    ++i15;
                }
                ++peakNum10;
            }
            this.applyPhasePropagation(source, spectrums);
        }
        if (this.outputOverlapCounter != 0) {
            int chan = 0;
            while (chan < nbChans) {
                Cmplx[] spectrum = spectrums[chan];
                int i16 = 0;
                while (i16 < this.nbBins) {
                    spectrum[i16].set(0.0f, 0.0f);
                    ++i16;
                }
                ++chan;
            }
        }
        this.outputOverlapCounter = (this.outputOverlapCounter + 1) % skipCount;
        i = 0;
        while (i < this.nbBins) {
            this.prevSourcePhases[i] = this.sourcePhases[i];
            ++i;
        }
        this.normalize(source, spectrums);
        ++this.resetCounter;
        if (this.resetCounter >= 500) {
            this.resetCounter = 0;
            i = 0;
            while (i < this.nbBins) {
                Cmplx pr = this.rotators[i];
                pr.mul(1.0f / pr.mag());
                ++i;
            }
        }
        if (this.mode.isCycleCounter()) {
            this.cycleCounter = (this.cycleCounter + 1) % this.inputOverlap;
        }
    }

    private void normalize(Cmplx[] source, Cmplx[][] spectrums) {
        int i;
        int i2 = 0;
        while (i2 < this.nbBins) {
            source[i2].im *= -1.0f;
            ++i2;
        }
        int chan = 0;
        while (chan < spectrums.length) {
            i = 0;
            while (i < this.nbBins) {
                spectrums[chan][i].im *= -1.0f;
                ++i;
            }
            ++chan;
        }
        i2 = 0;
        while (i2 < this.nbBins) {
            source[i2].mul(-1.0f);
            i2 += 2;
        }
        chan = 0;
        while (chan < spectrums.length) {
            i = 0;
            while (i < this.nbBins) {
                spectrums[chan][i].mul(-1.0f);
                i += 2;
            }
            ++chan;
        }
    }

    private double distance(double freq1, double freq2) {
        if (freq1 > freq2) {
            return freq1 / freq2;
        }
        return freq2 / freq1;
    }

    private void computePhaseShiftsAllBins(Cmplx[] source) {
        int i = 0;
        while (i < this.nbBins) {
            this.computePhaseShift(source, i, i);
            ++i;
        }
        this.populatePhaseShiftsIfWorth();
    }

    private void computePhaseShiftsAllPeaks(Cmplx[] source) {
        int nbPeaks = this.peakPicker.getNbPeaks();
        int peakIndex = 0;
        while (peakIndex < nbPeaks) {
            int binIndex = this.peakPicker.getPeakBinIndex(peakIndex);
            this.computePhaseShift(source, binIndex, binIndex);
            ++peakIndex;
        }
        this.populatePhaseShiftsIfWorth();
    }

    private void computePhaseShift(Cmplx[] source, int curBinNum, int prevBinNum) {
        float phase = this.sourcePhases[curBinNum];
        float prevPhase = this.prevSourcePhases[prevBinNum];
        float phaseShift = phase - prevPhase;
        if ((double)phaseShift > Math.PI) {
            phaseShift = (float)((double)phaseShift - Math.PI * 2);
        } else if ((double)phaseShift < -Math.PI) {
            phaseShift = (float)((double)phaseShift + Math.PI * 2);
        }
        this.phaseShifts0[curBinNum] = phaseShift;
    }

    private void populatePhaseShiftsIfWorth() {
        System.arraycopy(this.phaseShifts0, 0, this.phaseShifts, 0, this.nbBins);
    }

    private void calculateUpdatedPhases(int curBinNum, int prevBinNum) {
        double binFreq = Math.PI * 2 * (double)curBinNum / (double)this.blockSize;
        double inPhaseShift = this.phaseShifts[curBinNum];
        double expectedShift = (double)this.inHop * binFreq;
        double phi = FastMath.wrap(inPhaseShift - expectedShift);
        double frequency = binFreq + phi / (double)this.inHop;
        this.frequencies[curBinNum] = frequency > 0.0 ? frequency : binFreq;
        this.updatedPhases[curBinNum] = (double)this.prevOutSource[prevBinNum].phiApprox() + frequency * (double)this.outHop;
    }

    private void calculatePhasePropagation(float[] sourcePhases, int binNum) {
        this.calculatePhasePropagation(sourcePhases, binNum, binNum);
    }

    private void calculatePhasePropagation(float[] sourcePhases, int curBinNum, int prevBinNum) {
        this.calculateUpdatedPhases(curBinNum, prevBinNum);
        double phaseRotation = this.updatedPhases[curBinNum] - (double)sourcePhases[curBinNum];
        this.rotators[curBinNum].set(1.0f, (float)phaseRotation);
        this.rotators[curBinNum].toCartesianApprox();
    }

    private void applyPhasePropagation(Cmplx[] source, Cmplx[][] spectrums) {
        int nbChans = spectrums.length;
        int chan = 0;
        while (chan < nbChans) {
            Cmplx[] spectrum = spectrums[chan];
            int i = 0;
            while (i < this.nbBins) {
                spectrum[i].mul(this.rotators[i]);
                ++i;
            }
            ++chan;
        }
        int i = 0;
        while (i < this.nbBins) {
            this.prevOutSource[i].set(source[i]);
            this.prevOutSource[i].mul(this.rotators[i]);
            ++i;
        }
    }

    private void fillBandDominantPeaks() {
        if (this.cycleCounter == 0) {
            this.peakPicker.fillReverseArray();
            int band = 0;
            while (band < this.nbBands) {
                int peakNum = 0;
                double level = -1.0;
                int binNum = this.bounds[band];
                while (binNum < this.bounds[band + 1]) {
                    int p = this.peakPicker.findNearestPeakNum(binNum);
                    if (this.peakLevels[p] > level) {
                        peakNum = p;
                        level = this.peakLevels[p];
                    }
                    ++binNum;
                }
                this.lockPeaks[band] = peakNum;
                ++band;
            }
        }
    }

    public void stopProcessing() {
        super.stopProcessing();
        this.phaseShifts0 = null;
        this.phaseShifts = null;
        this.sourcePhases = null;
        this.prevSourcePhases = null;
        this.prevOutSource = null;
        this.frequencies = null;
        this.updatedPhases = null;
        this.unwrappedPhases = null;
        this.rotators = null;
        this.powerMags = null;
        this.peakPicker = null;
        this.peakFrequencies = null;
        this.peakLevels = null;
        this.prevPeakBins = null;
        this.prevDelays = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Mode {
        ZERO(false, false, false),
        VOCODER(false, false, false),
        LOOSE_LOCKING(false, false, false),
        LOOSE_ROTATOR_LOCKING(false, false, true),
        IDENTITY_LOCKING(true, false, false),
        FOLLOWING_LOCKING(true, false, false),
        SCALED_LOCKING(true, false, false),
        PHAVORIT(true, false, true),
        N_PEAKS_LOCKING_SCALED(true, false, true),
        N_PEAKS_LOCKING_IDENTITY(true, false, true),
        N_PEAKS_AVG(true, true, true),
        PIECEWISE_SHIFT(true, false, true),
        HARMONICS(true, true, true);

        private final boolean peakPicker;
        private final boolean cycleCounter;
        private final boolean complexStuff;

        private Mode(boolean peakPicker, boolean cycleCounter, boolean complexStuff) {
            this.peakPicker = peakPicker;
            this.cycleCounter = cycleCounter;
            this.complexStuff = complexStuff;
        }

        public boolean isPeakPicker() {
            return this.peakPicker;
        }

        public boolean isCycleCounter() {
            return this.cycleCounter;
        }

        public boolean isComplexStuff() {
            return this.complexStuff;
        }
    }
}

