/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import org.corebounce.common.utils.IDisposable;

public class ConcurrentAverageBuffer
implements IDisposable {
    private final int length;
    private final int capacity;
    private final float[] values;
    private final ThreadLocal<ThreadData> threadData;

    public ConcurrentAverageBuffer(int length, int capacity) {
        this.length = length;
        this.capacity = capacity += length + 1;
        this.values = new float[capacity];
        this.threadData = new ThreadLocal<ThreadData>(){

            @Override
            protected ThreadData initialValue() {
                ThreadData data = new ThreadData();
                data.lastClock = Integer.MIN_VALUE;
                data.lastSum = 0.0;
                return data;
            }
        };
    }

    public void push(float value, long clock) {
        int curIndex = (int)((clock + (long)this.length) % (long)this.capacity);
        this.values[curIndex] = value;
    }

    public float getAverage(long clock) {
        double sum = 0.0;
        ThreadData data = this.threadData.get();
        if (clock - data.lastClock < (long)this.length) {
            int oldOutIndex = (int)((data.lastClock + (long)this.capacity) % (long)this.capacity);
            int oldInIndex = (int)((data.lastClock + (long)this.length) % (long)this.capacity);
            int curIndex = (int)((clock + (long)this.length) % (long)this.capacity);
            sum = data.lastSum;
            do {
                oldOutIndex = (oldOutIndex + 1) % this.capacity;
                sum -= (double)this.values[oldOutIndex];
                oldInIndex = (oldInIndex + 1) % this.capacity;
                sum += (double)this.values[oldInIndex];
            } while (oldInIndex != curIndex);
        } else {
            int oldIndex = (int)(clock % (long)this.capacity);
            int curIndex = (int)((clock + (long)this.length) % (long)this.capacity);
            sum = 0.0;
            do {
                oldIndex = (oldIndex + 1) % this.capacity;
                sum += (double)this.values[oldIndex];
            } while (oldIndex != curIndex);
        }
        data.lastClock = clock;
        data.lastSum = sum;
        return (float)sum / (float)this.length;
    }

    public int getLength() {
        return this.length;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void dispose() {
        this.threadData.remove();
    }

    static class ThreadData {
        public long lastClock;
        public double lastSum;

        ThreadData() {
        }
    }
}

