/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.math.ParabolicInterpolator;
import org.corebounce.common.utils.Out;

public class PeakPicker {
    private final int nbBins;
    private float[] powerMags;
    private int[] bounds;
    private int[] peakLocations;
    private int nbPeaks;
    private int[] binIndexToPeakNum;

    public PeakPicker(int nbBins) {
        this.nbBins = nbBins;
        int maxNbPeaks = this.getMaxNbPeaks();
        this.bounds = new int[maxNbPeaks + 1];
        this.peakLocations = new int[maxNbPeaks];
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public int getMaxNbPeaks() {
        return this.nbBins / 2 + 1;
    }

    public static void fillPowerMags(Cmplx[] spectrum, @Out float[] powerMags) {
        if (spectrum.length != powerMags.length) {
            throw new IllegalArgumentException();
        }
        int i = 0;
        while (i < spectrum.length) {
            powerMags[i] = spectrum[i].powerMag();
            ++i;
        }
    }

    public void pickPeaks(float[] powerMags) {
        this.nbPeaks = 0;
        this.powerMags = powerMags;
        int i = 0;
        while (i < powerMags.length) {
            if (this.isPeak(i)) {
                this.peakLocations[this.nbPeaks] = i;
                ++this.nbPeaks;
            }
            ++i;
        }
        this.bounds[0] = 0;
        i = 0;
        while (i < this.nbPeaks - 1) {
            int peak1 = this.peakLocations[i];
            int peak2 = this.peakLocations[i + 1];
            int middle = (peak1 + peak2) / 2;
            while (middle > peak1 + 1 && this.getPowerMag(middle - 1) < this.getPowerMag(middle)) {
                --middle;
            }
            while (middle < peak2 - 1 && this.getPowerMag(middle + 1) < this.getPowerMag(middle)) {
                ++middle;
            }
            this.bounds[i + 1] = middle;
            ++i;
        }
        this.bounds[this.nbPeaks] = powerMags.length;
    }

    protected final float getPowerMag(int i) {
        if (i < 0 || i >= this.powerMags.length) {
            return 0.0f;
        }
        return this.powerMags[i];
    }

    protected boolean isPeak(int i) {
        float pm = this.getPowerMag(i);
        return pm >= this.getPowerMag(i - 1) && pm > this.getPowerMag(i + 1);
    }

    public void fillPeakFrequencies(@Out double[] peakFrequencies) {
        int i = 0;
        while (i < this.nbPeaks) {
            peakFrequencies[i] = this.interpolateFrequency(this.peakLocations[i]);
            ++i;
        }
    }

    public void fillPeakFrequencies(float[] decibels, @Out double[] peakFrequencies) {
        int i = 0;
        while (i < this.nbPeaks) {
            peakFrequencies[i] = this.interpolateFrequency(this.peakLocations[i], decibels);
            ++i;
        }
    }

    public void fillPeakPowerLevels(double[] peakFrequencies, @Out double[] peakPowerLevels) {
        int i = 0;
        while (i < this.nbPeaks) {
            peakPowerLevels[i] = this.interpolateLevel(this.peakLocations[i], peakFrequencies[i]);
            ++i;
        }
    }

    private double interpolateFrequency(int peakLocation) {
        double next;
        double cur = AudioMath.powerLevelToDb0(this.getPowerMag(peakLocation));
        double prev = AudioMath.powerLevelToDb0(this.getPowerMag(peakLocation - 1));
        double center = (double)peakLocation + ParabolicInterpolator.interpolateX(prev, cur, next = AudioMath.powerLevelToDb0(this.getPowerMag(peakLocation + 1)));
        if (Double.isInfinite(center) || Double.isNaN(center)) {
            center = peakLocation;
        }
        return center;
    }

    private double interpolateFrequency(int peakLocation, float[] decibels) {
        double prev = decibels[peakLocation];
        double cur = decibels[peakLocation];
        double next = decibels[peakLocation];
        double center = (double)peakLocation + ParabolicInterpolator.interpolateX(prev, cur, next);
        if (Double.isInfinite(center) || Double.isNaN(center)) {
            center = peakLocation;
        }
        return center;
    }

    private double interpolateLevel(int peakLocation, double peakFreq) {
        double cur = this.getPowerMag(peakLocation);
        double prev = this.getPowerMag(peakLocation - 1);
        double next = this.getPowerMag(peakLocation + 1);
        return ParabolicInterpolator.interpolateY(prev, cur, next, peakFreq - (double)peakLocation + 1.0);
    }

    public int getNbPeaks() {
        return this.nbPeaks;
    }

    public int getPeakBinIndex(int peakNum) {
        return this.peakLocations[peakNum];
    }

    public int getPeakLowerBin(int peakNum) {
        return this.bounds[peakNum];
    }

    public int getPeakUpperBin(int peakNum) {
        return this.bounds[peakNum + 1];
    }

    public void fillReverseArray() {
        if (this.binIndexToPeakNum == null) {
            this.binIndexToPeakNum = new int[this.nbBins];
        }
        int peakNum = 0;
        while (peakNum < this.nbPeaks) {
            int i = this.getPeakLowerBin(peakNum);
            while (i < this.getPeakUpperBin(peakNum)) {
                this.binIndexToPeakNum[i] = peakNum;
                ++i;
            }
            ++peakNum;
        }
    }

    public int findNearestPeakNum(int binIndex) {
        return this.binIndexToPeakNum[binIndex];
    }
}

