/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils;

import ch.tachyon.sonics.effect.base.stft.StftAnalyzer;
import ch.tachyon.sonics.effect.base.stft.StftSynthesizer;
import java.util.Arrays;
import java.util.Random;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;

public class StftBenchmark2 {
    private static final int BENCHMARK_DURATION = 20;
    private static final int BLOCKS = 10000;
    private final int hopSize;
    private float[] input;
    private float[] output;
    private int ioIndex;
    private StftAnalyzer analyzer;
    private float[] filter;
    private StftSynthesizer synthesizer;
    private float[] ioBuffer;

    public StftBenchmark2(int blockSize, int overlap) {
        this.hopSize = blockSize / overlap;
        Random rnd = new Random();
        this.input = new float[this.hopSize * 10000];
        int i = 0;
        while (i < this.input.length) {
            this.input[i] = rnd.nextFloat() - 0.5f;
            ++i;
        }
        this.output = new float[this.hopSize * 10000];
        this.ioBuffer = new float[this.hopSize];
        float[] analysisWindow = new float[blockSize];
        Windows.fillWindow(analysisWindow, Windows.HannCoefs);
        this.analyzer = new StftAnalyzer(blockSize, this.hopSize, 1, analysisWindow, false);
        this.filter = new float[blockSize / 2 + 1];
        Arrays.fill(this.filter, 1.0f);
        this.synthesizer = new StftSynthesizer(blockSize, this.hopSize, 1, analysisWindow, analysisWindow);
        this.analyzer.init();
        this.synthesizer.init(this.analyzer);
    }

    private void onePass() {
        int i = 0;
        while (i < this.hopSize) {
            this.ioBuffer[i] = this.input[i + this.ioIndex];
            ++i;
        }
        Cmplx[][] spectrums = this.analyzer.analyze(this.ioBuffer);
        Cmplx[] spectrum = spectrums[0];
        int i2 = 0;
        while (i2 < spectrum.length) {
            spectrum[i2].mul(this.filter[i2]);
            ++i2;
        }
        this.synthesizer.synthesize(spectrums, this.ioBuffer);
        i2 = 0;
        while (i2 < this.hopSize) {
            this.output[i2 + this.ioIndex] = this.ioBuffer[i2];
            ++i2;
        }
        this.ioIndex = (this.ioIndex + this.hopSize) % this.output.length;
    }

    public int benchmark() {
        long start = System.currentTimeMillis();
        long stop = start + 20000L;
        long nbPass = 0L;
        while (System.currentTimeMillis() < stop) {
            this.onePass();
            ++nbPass;
        }
        long duration = System.currentTimeMillis() - start;
        return (int)(nbPass * 1000L / duration);
    }

    public int getNbPerSecondForRealtime(int sampleRate) {
        return (sampleRate + this.hopSize - 1) / this.hopSize;
    }

    public static void main(String[] args) {
        int BLOCK_SIZE = 2048;
        int OVERLAP = 4;
        int SAMPLE_RATE = 44100;
        System.out.println("Creating benchmark...");
        StftBenchmark2 benchmark = new StftBenchmark2(2048, 4);
        System.out.println("Benchmark started. Duration is about 20s");
        int nbPass = benchmark.benchmark();
        System.out.println();
        System.out.println("Number of pass per second: " + nbPass);
        int nbRealtime = benchmark.getNbPerSecondForRealtime(44100);
        System.out.println("Realtime @ 44.1kHz mono: " + nbRealtime);
        double ratio = (double)nbPass / (double)nbRealtime;
        System.out.println("Ratio: " + ratio + " x realtime");
    }
}

