/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils.buffer;

import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.utils.Out;

public class Bufferizer2 {
    private final int nbChans;
    private final int capacity;
    private final float[][] buffers;
    private final Stepper2 stepper;

    public Bufferizer2(int nbChans, int inputSize, int outputSize, boolean immediateData) {
        if (!AudioMath.isPowerOfTwo(inputSize) || !AudioMath.isPowerOfTwo(outputSize)) {
            throw new IllegalArgumentException();
        }
        this.nbChans = nbChans;
        this.capacity = Math.max(inputSize, outputSize);
        this.buffers = new float[nbChans][this.capacity];
        this.stepper = new Stepper2(inputSize, outputSize, immediateData);
    }

    public void sumbit(float[][] data) {
        if (data.length != this.nbChans || data[0].length != this.stepper.inputSize) {
            throw new IllegalArgumentException();
        }
        int chan = 0;
        while (chan < this.nbChans) {
            System.arraycopy(data[chan], 0, this.buffers[chan], this.stepper.inIndex, this.stepper.inputSize);
            ++chan;
        }
        this.stepper.submit();
    }

    public int getNumOutputsAvailable() {
        return this.stepper.getNumOutputsAvailable();
    }

    public void retrieve(@Out float[][] data) {
        if (data.length != this.nbChans || data[0].length != this.stepper.outputSize) {
            throw new IllegalArgumentException();
        }
        if (this.stepper.outIndex + this.stepper.outputSize > this.capacity) {
            throw new IllegalStateException();
        }
        int chan = 0;
        while (chan < this.nbChans) {
            System.arraycopy(this.buffers[chan], this.stepper.outIndex, data[chan], 0, this.stepper.outputSize);
            ++chan;
        }
        this.stepper.retrieve();
    }

    public int getLatency() {
        return this.stepper.getLatency();
    }

    public String toString() {
        return "Bufferizer2 " + this.stepper.toString();
    }

    public static class Stepper2 {
        final int inputSize;
        final int outputSize;
        final int capacity;
        int inIndex;
        int outIndex;

        public Stepper2(int inputSize, int outputSize, boolean immediateData) {
            this.inputSize = inputSize;
            this.outputSize = outputSize;
            this.capacity = Math.max(inputSize, outputSize);
            if (inputSize < outputSize && immediateData) {
                this.inIndex = outputSize - inputSize;
            }
        }

        public void submit() {
            this.inIndex += this.inputSize;
        }

        public int getNumOutputsAvailable() {
            return this.inIndex / this.outputSize;
        }

        public void retrieve() {
            this.outIndex += this.outputSize;
            if (this.outIndex >= this.capacity) {
                assert (this.outIndex == this.capacity);
                assert (this.inIndex == this.capacity);
                this.outIndex = 0;
                this.inIndex = 0;
            }
        }

        public int getLatency() {
            if (this.inputSize < this.outputSize) {
                return this.outputSize - this.inputSize;
            }
            return 0;
        }

        public String toString() {
            return "[inputSize=" + this.inputSize + ", outputSize=" + this.outputSize + "]";
        }
    }
}

