/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils.buffer;

import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.Out;

public class ConcurrentFloatMatrixBuffer {
    private final int nbBins;
    private final int capacity;
    private final float[][] history;
    private final Cmplx[][] spectrums;

    public ConcurrentFloatMatrixBuffer(int nbBins, int capacity) {
        this.nbBins = nbBins;
        this.capacity = capacity;
        this.history = new float[capacity][nbBins];
        this.spectrums = Cmplx.newArray(capacity, nbBins);
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void push(float[] data, Cmplx[] spectrum, long clock) {
        int index = (int)(clock % (long)this.capacity);
        int i = 0;
        while (i < this.nbBins) {
            this.spectrums[index][i].set(spectrum[i]);
            this.history[index][i] = data[i];
            ++i;
        }
    }

    public float getValue(int bin, int offset, long clock) {
        if (bin < 0 || bin >= this.nbBins) {
            return 0.0f;
        }
        int index = (int)((clock + (long)offset + (long)this.capacity) % (long)this.capacity);
        int pos = (index + offset + this.capacity) % this.capacity;
        return this.history[pos][bin];
    }

    public void pop(int offset, @Out Cmplx[] spectrum, long clock) {
        int index = (int)((clock + (long)offset + (long)this.capacity) % (long)this.capacity);
        int i = 0;
        while (i < this.nbBins) {
            spectrum[i].set(this.spectrums[index][i]);
            ++i;
        }
    }

    public void pop(int offset, @Out Cmplx[] spectrum, @Out float[] data, long clock) {
        int index = (int)((clock + (long)offset + (long)this.capacity) % (long)this.capacity);
        int i = 0;
        while (i < this.nbBins) {
            spectrum[i].set(this.spectrums[index][i]);
            data[i] = this.history[index][i];
            ++i;
        }
    }
}

