/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils.buffer;

public class ConcurrentHistoryBuffer {
    private final int size;
    private final float[] data;

    public ConcurrentHistoryBuffer(int size, int capacity) {
        this.size = size;
        this.data = new float[capacity];
    }

    public void write(float[] input, long clock) {
        this.write(input, input.length, clock);
    }

    public void write(float[] input, int length, long clock) {
        int index = (int)(clock % (long)this.data.length);
        int i = 0;
        while (i < length) {
            this.data[index] = input[i];
            index = (index + 1) % this.data.length;
            ++i;
        }
    }

    public void write(float value, long clock) {
        int index = (int)(clock % (long)this.data.length);
        this.data[index] = value;
    }

    public void read(int pastOffset, float[] output, long clock) {
        this.read(pastOffset, output, output.length, clock);
    }

    public void read(int pastOffset, float[] output, int amount, long clock) {
        if (pastOffset < -this.size) {
            throw new IllegalArgumentException();
        }
        int index = (int)(clock % (long)this.data.length);
        int offset = (index + this.data.length + pastOffset) % this.data.length;
        if (offset < 0) {
            throw new IllegalArgumentException("Read past capacity");
        }
        int i = 0;
        while (i < amount) {
            output[i] = this.data[(i + offset) % this.data.length];
            ++i;
        }
    }

    public float read(int pastOffset, long clock) {
        int index = (int)(clock % (long)this.data.length);
        int offset = (index + this.data.length + pastOffset) % this.data.length;
        if (offset < 0) {
            throw new IllegalArgumentException("Read past capacity");
        }
        return this.data[offset];
    }
}

