/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils.buffer;

import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.Out;

public class FloatMatrixBuffer {
    private final int nbBins;
    private final int size;
    private final float[][] history;
    private final Cmplx[][] spectrums;
    private int index;

    public FloatMatrixBuffer(int nbBins, int size) {
        this.nbBins = nbBins;
        this.size = size;
        this.history = new float[size][nbBins];
        this.spectrums = Cmplx.newArray(size, nbBins);
    }

    public int getNbBins() {
        return this.nbBins;
    }

    public int getSize() {
        return this.size;
    }

    public void push(float[] data, Cmplx[] spectrum) {
        int i = 0;
        while (i < this.nbBins) {
            this.spectrums[this.index][i].set(spectrum[i]);
            this.history[this.index][i] = data[i];
            ++i;
        }
    }

    public float getValue(int bin, int offset) {
        if (bin < 0 || bin >= this.nbBins) {
            return 0.0f;
        }
        int pos = (this.index + offset + this.size) % this.size;
        return this.history[pos][bin];
    }

    public void pop(int offset, @Out Cmplx[] spectrum) {
        int pos = (this.index + offset + this.size) % this.size;
        int i = 0;
        while (i < this.nbBins) {
            spectrum[i].set(this.spectrums[pos][i]);
            ++i;
        }
        this.index = (this.index + 1) % this.size;
    }

    public void pop(int offset, @Out Cmplx[] spectrum, @Out float[] data) {
        int pos = (this.index + offset + this.size) % this.size;
        int i = 0;
        while (i < this.nbBins) {
            spectrum[i].set(this.spectrums[pos][i]);
            data[i] = this.history[pos][i];
            ++i;
        }
        this.index = (this.index + 1) % this.size;
    }
}

