/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.sonics.effect.utils.buffer;

import java.util.Arrays;
import org.corebounce.common.utils.Out;

public class VarySpeedArrayBuffer {
    private final double speedChange;
    private final int arrSize;
    private final float[][] buffer;
    private int readIndex;
    private double writeIndex;
    private float[] lastValues;
    private float[] curSums;
    private int nbValues;

    public VarySpeedArrayBuffer(double speedChange, int arrSize, int outCapacity, int initialOut) {
        this.speedChange = speedChange;
        this.arrSize = arrSize;
        this.buffer = new float[outCapacity][arrSize];
        this.readIndex = outCapacity - initialOut;
        this.writeIndex = 0.5;
        this.curSums = new float[arrSize];
        this.lastValues = new float[arrSize];
    }

    public void push(float[][] data) {
        int k = 0;
        while (k < data.length) {
            int i = 0;
            while (i < this.arrSize) {
                int n = i;
                this.curSums[n] = this.curSums[n] + data[k][i];
                this.lastValues[i] = data[k][i];
                ++i;
            }
            ++this.nbValues;
            int prevIndex = (int)this.writeIndex;
            this.writeIndex += this.speedChange;
            int nextIndex = (int)this.writeIndex;
            if (nextIndex != prevIndex) {
                if (nextIndex >= this.buffer.length) {
                    nextIndex -= this.buffer.length;
                    this.writeIndex -= (double)this.buffer.length;
                }
                if (nextIndex == this.readIndex) {
                    throw new IllegalStateException("Buffer overflow");
                }
                if (this.nbValues == 0) {
                    int i2 = 0;
                    while (i2 < this.arrSize) {
                        this.buffer[prevIndex][i2] = this.lastValues[i2];
                        ++i2;
                    }
                } else {
                    float correction = 1.0f / (float)this.nbValues;
                    int i3 = 0;
                    while (i3 < this.arrSize) {
                        this.buffer[prevIndex][i3] = this.curSums[i3] * correction;
                        ++i3;
                    }
                }
                Arrays.fill(this.curSums, 0.0f);
                this.nbValues = 0;
            }
            ++k;
        }
    }

    public void pop(@Out float[][] data) {
        int i = 0;
        while (i < data.length) {
            if (this.readIndex == (int)this.writeIndex) {
                throw new IllegalStateException("Buffer underflow");
            }
            System.arraycopy(this.buffer[this.readIndex], 0, data[i], 0, this.arrSize);
            this.readIndex = (this.readIndex + 1) % this.buffer.length;
            ++i;
        }
    }
}

