/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.file;

import ch.tachyon.tunnel.audio.file.AudioFileTypes;
import ch.tachyon.tunnel.audio.file.AudioInputStreamSource;
import ch.tachyon.tunnel.audio.file.AudioSourceInputStream;
import ch.tachyon.tunnel.audio.file.RandomFileInputStream;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.utils.IOUtils;
import ch.tachyon.tunnel.utils.IProgressMonitor;
import ch.tachyon.tunnel.utils.OperationAbortedException;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioFileIO {
    public static IMultiChanAudioSource createAudioSource(File file) throws IOException, UnsupportedAudioFileException {
        RandomFileInputStream input = new RandomFileInputStream(file);
        return AudioFileIO.createAudioSource(file.getName(), input);
    }

    public static IMultiChanAudioSource createAudioSource(File file, IProgressMonitor progress) throws IOException, UnsupportedAudioFileException {
        RandomFileInputStream input = new RandomFileInputStream(file, progress);
        return AudioFileIO.createAudioSource(file.getName(), input);
    }

    public static IMultiChanAudioSource createAudioSource(String fileName, InputStream stream) throws IOException, UnsupportedAudioFileException {
        AudioFileTypes aft = AudioFileTypes.instance();
        AudioInputStream audioInput = aft.getAudioInputStream(fileName, stream);
        return new AudioInputStreamSource(audioInput);
    }

    public static void saveAudioFile(IMultiChanAudioSource audioSource, File outputFile, AudioFileFormat saveFormat, IProgressMonitor progress) throws IOException {
        AudioInputStream input = AudioSourceInputStream.createAudioInputStream(audioSource, saveFormat.getFormat(), progress, saveFormat.getFrameLength());
        try {
            AudioFileTypes.write(input, saveFormat.getType(), outputFile);
        }
        finally {
            IOUtils.close(audioSource);
            input.close();
        }
    }

    public static void saveAudioFile(IMultiChanAudioSource audioSource, OutputStream target, AudioFileFormat saveFormat, IProgressMonitor progress) throws IOException, OperationAbortedException {
        if (saveFormat.getFrameLength() == -1 && !saveFormat.getType().equals(AudioFileFormat.Type.AU)) {
            throw new IllegalArgumentException("Writing to a stream with unspecified length is not allowed");
        }
        AudioSourceInputStream source = AudioSourceInputStream.createAudioSourceInputStream(audioSource, saveFormat.getFormat(), progress, saveFormat.getFrameLength());
        AudioInputStream input = new AudioInputStream(source, saveFormat.getFormat(), saveFormat.getFrameLength());
        try {
            AudioFileTypes.write(input, saveFormat.getType(), target);
        }
        finally {
            IOUtils.close(audioSource);
            target.close();
            input.close();
        }
        OperationAbortedException abortion = source.aborted();
        if (abortion != null) {
            throw abortion;
        }
    }

    public static void close(Object streamWrapper) throws IOException {
        if (streamWrapper instanceof Closeable) {
            ((Closeable)streamWrapper).close();
        }
    }
}

