/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.file;

import ch.tachyon.tunnel.audio.file.AudioEncodingType;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.utils.IProgressMonitor;
import ch.tachyon.tunnel.utils.OperationAbortedException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import org.tritonus.share.sampled.Encodings;

class AudioSourceInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 32768;
    private final IMultiChanAudioSource source;
    private final AudioEncodingType encoding;
    private final float[][] samples;
    private final float[] channels;
    private final byte[] buffer;
    private final int nbChannels;
    private int bufferLength;
    private int bufferOffset;
    private final IProgressMonitor progress;
    private final long progressLength;
    private long progressOffset;
    private OperationAbortedException abortion;

    public AudioSourceInputStream(IMultiChanAudioSource source, int nbChannels, AudioEncodingType encoding, IProgressMonitor progress, long length) {
        this.source = source;
        this.encoding = encoding;
        this.nbChannels = nbChannels;
        this.samples = new float[nbChannels][32768];
        this.channels = new float[32768 * nbChannels];
        this.buffer = new byte[32768 * encoding.getBytesPerSample() * nbChannels];
        this.bufferLength = this.buffer.length;
        this.bufferOffset = this.buffer.length;
        this.progress = progress;
        this.progressLength = length;
    }

    public int read() throws IOException {
        if (this.bufferLength == 0) {
            return -1;
        }
        if (this.bufferOffset >= this.bufferLength) {
            this.fillNextBuffer();
            if (this.bufferLength == 0) {
                return -1;
            }
        }
        return this.buffer[this.bufferOffset++] & 0xFF;
    }

    private void fillNextBuffer() throws IOException {
        int nbFrames = this.abortion != null ? 0 : this.source.readSamples(this.samples);
        if (nbFrames < 32768) {
            int chan = 0;
            while (chan < this.nbChannels) {
                Arrays.fill(this.samples[chan], nbFrames, 32768, 0.0f);
                ++chan;
            }
            this.bufferLength = nbFrames * this.encoding.getBytesPerSample() * this.nbChannels;
        }
        this.bufferOffset = 0;
        this.encodeChannels(this.samples, this.channels, nbFrames);
        this.encoding.encode(this.channels, this.buffer, nbFrames * this.nbChannels);
        if (this.progress != null && this.abortion == null) {
            try {
                this.progress.setProgress(this.progressOffset, this.progressLength);
                this.progressOffset += (long)nbFrames;
            }
            catch (OperationAbortedException ex) {
                this.abortion = ex;
            }
        }
    }

    private void encodeChannels(float[][] source, float[] target, int nbFrames) {
        if (this.nbChannels == 1) {
            System.arraycopy(source[0], 0, target, 0, nbFrames);
        } else {
            int chan = 0;
            while (chan < this.nbChannels) {
                int i = 0;
                while (i < nbFrames) {
                    target[i * this.nbChannels + chan] = source[chan][i];
                    ++i;
                }
                ++chan;
            }
        }
    }

    public OperationAbortedException aborted() {
        OperationAbortedException result = this.abortion;
        this.abortion = null;
        return result;
    }

    public static AudioInputStream createAudioInputStream(IMultiChanAudioSource source, AudioFormat format, IProgressMonitor progress, long length) {
        AudioSourceInputStream stream = AudioSourceInputStream.createAudioSourceInputStream(source, format, progress, length);
        return new AudioInputStream(stream, format, length);
    }

    public static AudioSourceInputStream createAudioSourceInputStream(IMultiChanAudioSource source, AudioFormat format, IProgressMonitor progress, long length) {
        AudioEncodingType encoding = null;
        int bits = format.getSampleSizeInBits();
        boolean bigEndian = format.isBigEndian();
        if (format.getEncoding().equals(AudioFormat.Encoding.PCM_SIGNED)) {
            if (bits == 8) {
                encoding = AudioEncodingType.ENC_8BIT_S;
            } else if (bits == 16) {
                encoding = bigEndian ? AudioEncodingType.ENC_16BIT_BE : AudioEncodingType.ENC_16BIT_LE;
            } else if (bits == 24) {
                encoding = bigEndian ? AudioEncodingType.ENC_24BIT_BE : AudioEncodingType.ENC_24BIT_LE;
            } else if (bits == 32) {
                encoding = bigEndian ? AudioEncodingType.ENC_32BIT_BE : AudioEncodingType.ENC_32BIT_LE;
            }
        } else if (format.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED)) {
            if (bits == 8) {
                encoding = AudioEncodingType.ENC_8BIT_U;
            }
        } else if (format.getEncoding().equals(Encodings.PCM_IEEE_FLOAT)) {
            if (bits == 64) {
                encoding = bigEndian ? AudioEncodingType.ENC_DOUBLE_BE : AudioEncodingType.ENC_DOUBLE_LE;
            } else {
                AudioEncodingType audioEncodingType = encoding = bigEndian ? AudioEncodingType.ENC_FLOAT_BE : AudioEncodingType.ENC_FLOAT_LE;
            }
        }
        if (encoding == null) {
            throw new UnsupportedOperationException("Unsupported audio format. Only PCM_SIGNED 8/16/24/32bit, PCM_UNSIGNED 8bit and PCM_FLOAT are supported");
        }
        AudioSourceInputStream stream = new AudioSourceInputStream(source, format.getChannels(), encoding, progress, length);
        return stream;
    }
}

