/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.file;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.ISingleChanAudioSource;
import ch.tachyon.tunnel.utils.IOUtils;
import ch.tachyon.tunnel.utils.Monitor;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import javax.sound.sampled.AudioFormat;

public class DemuxAudioSource
implements IMultiChanAudioSource,
Closeable {
    private static final int MIN_MC_LENGTH = 128;
    private static final int DEFAULT_MC_LENGTH = 2048;
    private static final int MAX_MC_LENGTH = 32768;
    private final ISingleChanAudioSource[] audioSources;
    private final IMultiChanAudioSource mcAudioSource;
    private final ISingleChanAudioSource[] resultSources;
    private final List<Queue<float[]>> channelQueues;
    private final int[] channelIndex;
    private final BitSet activeChannels = new BitSet();
    private final Object lock = new Monitor("DemuxAudioSource");
    private boolean started = false;

    public DemuxAudioSource(ISingleChanAudioSource[] audioSources) {
        this.audioSources = audioSources;
        this.mcAudioSource = null;
        this.resultSources = null;
        this.channelQueues = null;
        this.channelIndex = null;
    }

    public DemuxAudioSource(IMultiChanAudioSource mcAudioSource) {
        this.mcAudioSource = mcAudioSource;
        this.audioSources = null;
        int nbChannels = mcAudioSource.getAudioFormat().getChannels();
        this.resultSources = new ISingleChanAudioSource[nbChannels];
        this.channelQueues = new ArrayList<Queue<float[]>>(nbChannels);
        int i = 0;
        while (i < nbChannels) {
            this.channelQueues.add(new LinkedList());
            ++i;
        }
        this.channelIndex = new int[nbChannels];
    }

    public AudioFormat getAudioFormat() {
        if (this.mcAudioSource != null) {
            AudioFormat af = this.mcAudioSource.getAudioFormat();
            return new AudioFormat(af.getSampleRate(), af.getSampleSizeInBits(), 1, !af.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED), af.isBigEndian());
        }
        AudioFormat af = this.audioSources[0].getAudioFormat();
        return new AudioFormat(af.getSampleRate(), af.getSampleSizeInBits(), this.audioSources.length, !af.getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED), af.isBigEndian());
    }

    public int getNbChannels() {
        if (this.mcAudioSource != null) {
            return this.mcAudioSource.getAudioFormat().getChannels();
        }
        return this.audioSources.length;
    }

    private void readNextMultiChanBlock(int length) {
        float[][] block;
        int amount;
        if (length < 128 || length > 32768) {
            length = 2048;
        }
        if ((amount = this.mcAudioSource.readSamples(block = new float[this.channelIndex.length][length])) <= 0) {
            return;
        }
        if (amount < length) {
            float[][] shrunk = new float[block.length][amount];
            int c = 0;
            while (c < block.length) {
                System.arraycopy(block[c], 0, shrunk[c], 0, amount);
                ++c;
            }
            block = shrunk;
        }
        int c = 0;
        while (c < block.length) {
            if (this.activeChannels.get(c)) {
                this.channelQueues.get(c).add(block[c]);
            }
            ++c;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int readSamples(int chan, float[] target) {
        if (this.audioSources != null) {
            return this.audioSources[chan].readSamples(target);
        }
        Object object = this.lock;
        synchronized (object) {
            this.started = true;
            int remaining = target.length;
            int offset = 0;
            Queue<float[]> queue = this.channelQueues.get(chan);
            while (remaining > 0) {
                if (queue.isEmpty()) {
                    assert (this.channelIndex[chan] == 0);
                    this.readNextMultiChanBlock(remaining);
                }
                if (queue.isEmpty()) {
                    return offset;
                }
                float[] block = queue.peek();
                int amount = Math.min(remaining, block.length - this.channelIndex[chan]);
                System.arraycopy(block, this.channelIndex[chan], target, offset, amount);
                offset += amount;
                remaining -= amount;
                int n = chan;
                this.channelIndex[n] = this.channelIndex[n] + amount;
                if (this.channelIndex[chan] < block.length) continue;
                queue.remove();
                this.channelIndex[chan] = 0;
            }
        }
        return target.length;
    }

    public int readSamples(float[][] target) {
        if (this.mcAudioSource != null) {
            return this.mcAudioSource.readSamples(target);
        }
        int result = 0;
        int i = 0;
        while (i < this.audioSources.length) {
            result = this.audioSources[i].readSamples(target[i]);
            ++i;
        }
        return result;
    }

    public int getNumberOfChannels() {
        if (this.mcAudioSource != null) {
            return this.mcAudioSource.getAudioFormat().getChannels();
        }
        return this.audioSources.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ISingleChanAudioSource getSourceForChannel(int chan) {
        if (this.resultSources[chan] == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.started) {
                    throw new IllegalStateException("Cannot create a single chan source after reading has started. You must create all the sources before reading");
                }
                this.resultSources[chan] = new SingleChanSource(chan);
                this.activeChannels.set(chan);
            }
        }
        return this.resultSources[chan];
    }

    public void close() throws IOException {
        if (this.mcAudioSource != null) {
            IOUtils.close(this.mcAudioSource);
        }
        if (this.audioSources != null) {
            ISingleChanAudioSource[] iSingleChanAudioSourceArray = this.audioSources;
            int n = this.audioSources.length;
            int n2 = 0;
            while (n2 < n) {
                ISingleChanAudioSource source = iSingleChanAudioSourceArray[n2];
                IOUtils.close(source);
                ++n2;
            }
        }
    }

    class SingleChanSource
    implements ISingleChanAudioSource,
    Closeable {
        private final int chan;

        private SingleChanSource(int chan) {
            this.chan = chan;
        }

        public int readSamples(float[] target) {
            return DemuxAudioSource.this.readSamples(this.chan, target);
        }

        public void close() throws IOException {
            DemuxAudioSource.this.close();
        }

        public AudioFormat getAudioFormat() {
            return DemuxAudioSource.this.getAudioFormat();
        }
    }
}

