/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine;

import ch.tachyon.tunnel.engine.PluginsImpl;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.utils.ParentLastUrlClassLoader;
import ch.tachyon.tunnel.host.effect.IEffect;
import ch.tachyon.tunnel.host.engine.IPluginBundle;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginBundleImpl
implements IPluginBundle {
    private final URL url;
    private final boolean external;
    private final MtContext mtContext = new MtContext();
    private ClassLoader classLoader;
    private String bundleName;
    private static Map<String, WeakReference<ClassLoader>> classLoaderCache = new HashMap<String, WeakReference<ClassLoader>>();

    public PluginBundleImpl(File jarFile, boolean external) {
        this(PluginBundleImpl.file2url(jarFile), external);
    }

    private static URL file2url(File file) {
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public PluginBundleImpl(URL jarFileUrl, boolean external) {
        this.url = jarFileUrl;
        this.external = external;
    }

    private ClassLoader classLoader() {
        if (this.classLoader == null) {
            WeakReference<ClassLoader> classLoaderRef = classLoaderCache.get(this.url.toExternalForm());
            if (classLoaderRef != null) {
                this.classLoader = (ClassLoader)classLoaderRef.get();
            }
            if (this.classLoader == null) {
                Debug.info("[New ClassLoader created]", new Object[0]);
                this.classLoader = new ParentLastUrlClassLoader(new URL[]{this.url}, this.external);
                classLoaderRef = new WeakReference<ClassLoader>(this.classLoader);
                classLoaderCache.put(this.url.toExternalForm(), classLoaderRef);
            }
        }
        return this.classLoader;
    }

    @Override
    public ClassLoader getClassLoader(boolean create) {
        if (create) {
            return this.classLoader();
        }
        return this.classLoader;
    }

    @Override
    public IMtContext getMtContext() {
        return this.mtContext;
    }

    @Override
    public String getUrlString() {
        return this.url.toExternalForm();
    }

    @Override
    public String getName() {
        if (this.bundleName != null) {
            return this.bundleName;
        }
        ClassLoader cl = this.classLoader();
        InputStream stream = cl.getResourceAsStream("META-INF/MANIFEST.MF");
        if (stream == null) {
            return null;
        }
        try {
            Manifest manifest = new Manifest(stream);
            String string = this.bundleName = manifest.getMainAttributes().getValue("Title");
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public <E extends IEffect> List<E> loadAllPlugins(Class<E> hostInterface) throws IOException {
        ArrayList<Class<? extends IEffect>> singleTonIntf = new ArrayList<Class<? extends IEffect>>(1);
        singleTonIntf.add(hostInterface);
        List<IEffect> result0 = this.loadAllPlugins(singleTonIntf);
        for (IEffect effect : result0) {
            assert (hostInterface.isAssignableFrom(effect.getClass()));
        }
        List<IEffect> result = result0;
        return result;
    }

    @Override
    public List<IEffect> loadAllPlugins(List<Class<? extends IEffect>> hostInterfaces) throws IOException {
        return PluginsImpl.loadAllPlugins(this.classLoader(), this.mtContext, hostInterfaces);
    }

    @Override
    public <E extends IEffect> E loadPlugin(Class<E> type, String className) {
        return PluginsImpl.loadPlugin(this.classLoader(), this.mtContext, type, className);
    }

    @Override
    public void releaseLoader() {
        this.classLoader = null;
    }

    public String toString() {
        return "PluginBundle [url=" + this.url + "]";
    }
}

