/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine;

import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.bridges.McEffectFromMcEffect;
import ch.tachyon.tunnel.engine.bridges.McPullFromMcEffect;
import ch.tachyon.tunnel.engine.bridges.McPullFromMcPull;
import ch.tachyon.tunnel.engine.bridges.McPushFromMcPush;
import ch.tachyon.tunnel.engine.bridges.ScEffectFromScEffect;
import ch.tachyon.tunnel.engine.bridges.ScPullFromScEffect;
import ch.tachyon.tunnel.engine.bridges.ScPullFromScPull;
import ch.tachyon.tunnel.engine.bridges.ScPullFromScPush;
import ch.tachyon.tunnel.engine.bridges.ScPushFromScEffect;
import ch.tachyon.tunnel.engine.bridges.ScPushFromScPull;
import ch.tachyon.tunnel.engine.bridges.ScPushFromScPush;
import ch.tachyon.tunnel.engine.bridges.chan.IScEffectFactory;
import ch.tachyon.tunnel.engine.bridges.chan.McEffectFromScEffect;
import ch.tachyon.tunnel.engine.bridges.chan.McFromScBase;
import ch.tachyon.tunnel.engine.bridges.chan.McPullFromScPull;
import ch.tachyon.tunnel.engine.bridges.chan.McPushFromScPush;
import ch.tachyon.tunnel.engine.bridges.mthread.BridgeMcSimpleAsPull;
import ch.tachyon.tunnel.engine.bridges.mthread.BridgeMcSimpleAsPush;
import ch.tachyon.tunnel.engine.bridges.mthread.BridgeScSimpleAsPull;
import ch.tachyon.tunnel.engine.bridges.mthread.BridgeScSimpleAsPush;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.bridges.mthread.MtMcPull;
import ch.tachyon.tunnel.engine.bridges.mthread.MtMcPush;
import ch.tachyon.tunnel.engine.bridges.mthread.MtScPull;
import ch.tachyon.tunnel.engine.bridges.mthread.MtScPush;
import ch.tachyon.tunnel.engine.utils.AnnotationUtils;
import ch.tachyon.tunnel.engine.utils.CodecInputStream;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IEffect;
import ch.tachyon.tunnel.host.effect.IPushEffect;
import ch.tachyon.tunnel.host.effect.ISingleChanEffect;
import ch.tachyon.tunnel.host.effect.ISingleChanPullEffect;
import ch.tachyon.tunnel.host.effect.ISingleChanPushEffect;
import ch.tachyon.tunnel.plugin.IMultiChanEffect;
import ch.tachyon.tunnel.plugin.IMultiChanPullEffect;
import ch.tachyon.tunnel.plugin.IMultiChanPushEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.IPullEffect;
import ch.tachyon.tunnel.plugin.ISimpleEffect;
import ch.tachyon.tunnel.plugin.opt.thread.MultiThreading;
import ch.tachyon.tunnel.utils.Debug;
import ch.tachyon.tunnel.utils.Pair;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsImpl {
    private static final String PLUGINS_RESOURCE = "META-INF/services/ch.tachyon.tunnel.Plugins";
    private static final int PRIORITY_STRAIGHT = 0;
    private static final int PRIORITY_EASY = 1;
    private static final int PRIORITY_HARD = 2;
    private static final Map<Pair<Class<? extends IPlugin>, Class<? extends IEffect>>, Class<? extends IEffect>> bridges = new HashMap<Pair<Class<? extends IPlugin>, Class<? extends IEffect>>, Class<? extends IEffect>>();
    private static final Map<Class<? extends IEffect>, Integer> bridgePriorities = new HashMap<Class<? extends IEffect>, Integer>();
    private static final Map<Class<? extends IEffect>, Pair<Class<? extends IEffect>, Class<? extends McFromScBase<?, ?>>>> singleToMultiConverters = new HashMap();
    private static final Set<Class<? extends IEffect>> multiChanInterfaces = new HashSet<Class<? extends IEffect>>();

    static {
        PluginsImpl.addBridge(ISimpleEffect.class, ISingleChanEffect.class, ScEffectFromScEffect.class, 0);
        PluginsImpl.addBridge(IMultiChanEffect.class, ch.tachyon.tunnel.host.effect.ISimpleEffect.class, McEffectFromMcEffect.class, 0);
        PluginsImpl.addBridge(IPullEffect.class, ISingleChanPullEffect.class, ScPullFromScPull.class, 0);
        PluginsImpl.addBridge(IMultiChanPullEffect.class, ch.tachyon.tunnel.host.effect.IPullEffect.class, McPullFromMcPull.class, 0);
        PluginsImpl.addBridge(ch.tachyon.tunnel.plugin.IPushEffect.class, ISingleChanPushEffect.class, ScPushFromScPush.class, 0);
        PluginsImpl.addBridge(IMultiChanPushEffect.class, IPushEffect.class, McPushFromMcPush.class, 0);
        PluginsImpl.addBridge(ISimpleEffect.class, ISingleChanPullEffect.class, ScPullFromScEffect.class, 1);
        PluginsImpl.addBridge(ISimpleEffect.class, ISingleChanPushEffect.class, ScPushFromScEffect.class, 1);
        PluginsImpl.addBridge(IMultiChanEffect.class, ch.tachyon.tunnel.host.effect.IPullEffect.class, McPullFromMcEffect.class, 1);
        PluginsImpl.addBridge(IPullEffect.class, ISingleChanPushEffect.class, ScPushFromScPull.class, 2);
        PluginsImpl.addBridge(ch.tachyon.tunnel.plugin.IPushEffect.class, ISingleChanPullEffect.class, ScPullFromScPush.class, 2);
        multiChanInterfaces.add(ch.tachyon.tunnel.host.effect.ISimpleEffect.class);
        multiChanInterfaces.add(ch.tachyon.tunnel.host.effect.IPullEffect.class);
        multiChanInterfaces.add(IPushEffect.class);
        PluginsImpl.addSingleToMultiConverter(ISingleChanEffect.class, ch.tachyon.tunnel.host.effect.ISimpleEffect.class, McEffectFromScEffect.class);
        PluginsImpl.addSingleToMultiConverter(ISingleChanPushEffect.class, IPushEffect.class, McPushFromScPush.class);
        PluginsImpl.addSingleToMultiConverter(ISingleChanPullEffect.class, ch.tachyon.tunnel.host.effect.IPullEffect.class, McPullFromScPull.class);
    }

    private static <P extends IPlugin, H extends IEffect> void addBridge(Class<P> pluginInterface, Class<H> hostInterface, Class<? extends H> bridgeType, int priority) {
        bridges.put(new Pair<Class<P>, Class<H>>(pluginInterface, hostInterface), bridgeType);
        bridgePriorities.put(bridgeType, priority);
    }

    private static <S extends IEffect, M extends IEffect, C extends McFromScBase<M, S>> void addSingleToMultiConverter(Class<S> singleInterface, Class<M> multiInterface, Class<C> converter) {
        singleToMultiConverters.put(multiInterface, new Pair<Class<S>, Class<C>>(singleInterface, converter));
    }

    public static List<IEffect> loadAllPlugins(ClassLoader classLoader, MtContext mtContext, List<Class<? extends IEffect>> hostInterfaces) throws IOException {
        ArrayList<IEffect> plugins = new ArrayList<IEffect>();
        Enumeration<URL> pluginLists = classLoader.getResources(PLUGINS_RESOURCE);
        while (pluginLists.hasMoreElements()) {
            URL pluginList = pluginLists.nextElement();
            InputStream stream = pluginList.openStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            try {
                String line = reader.readLine();
                while (line != null) {
                    String className;
                    IEffect effect;
                    if (!line.trim().equals("") && !line.trim().startsWith("#") && (effect = PluginsImpl.loadEffect(classLoader, hostInterfaces, className = line.trim(), mtContext)) != null) {
                        plugins.add(effect);
                    }
                    line = reader.readLine();
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
        return plugins;
    }

    public static <E extends IEffect> E loadPlugin(ClassLoader classLoader, MtContext mtContext, Class<E> type, String className) {
        ArrayList<Class<? extends IEffect>> singleton = new ArrayList<Class<? extends IEffect>>(1);
        singleton.add(type);
        IEffect result = PluginsImpl.loadEffect(classLoader, singleton, className, mtContext);
        assert (result == null || type.isInstance(result));
        return (E)result;
    }

    private static IEffect loadEffect(ClassLoader cl, List<Class<? extends IEffect>> hostInterfaces, String className, MtContext mtContext) {
        Class<?> type;
        block5: {
            type = Class.forName(className, true, cl);
            if (IPlugin.class.isAssignableFrom(type)) break block5;
            Debug.error("Not a plugin: {0}", className);
            return null;
        }
        try {
            Class<?> effectType = type;
            return PluginsImpl.createEffect(hostInterfaces, effectType, mtContext);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (InstantiationException ex) {
            ex.printStackTrace();
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    private static IEffect createEffect(List<Class<? extends IEffect>> hostInterfaces, Class<? extends IPlugin> effectType, MtContext mtContext) throws InstantiationException, IllegalAccessException {
        List<Class<? extends IPlugin>> effectInterfaces = PluginsImpl.getEffectInterfaces(effectType);
        for (Class<? extends IPlugin> effectInterface : effectInterfaces) {
            IEffect result = PluginsImpl.createEffect(hostInterfaces, effectType, effectInterface, mtContext);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Properties loadProperties(Class<?> forClass) {
        Properties properties = new Properties();
        InputStream input = forClass.getResourceAsStream(String.valueOf(forClass.getSimpleName()) + ".properties");
        if (input == null) {
            return properties;
        }
        try {
            CodecInputStream codec = new CodecInputStream(input, "UTF-8", "ISO-8859-1");
            properties.load(codec);
            input.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return properties;
    }

    /*
     * WARNING - void declaration
     */
    private static IEffect createEffect(List<Class<? extends IEffect>> hostInterfaces, final Class<? extends IPlugin> effectType, Class<? extends IPlugin> effectInterface, MtContext mtContext) throws InstantiationException, IllegalAccessException {
        McFromScBase<?, ?> bridged;
        void var10_17;
        ArrayList<Pair<Class<? extends IEffect>, Object>> targetInterfaces = new ArrayList<Pair<Class<? extends IEffect>, Object>>();
        for (Class<? extends IEffect> hostInterface : hostInterfaces) {
            targetInterfaces.add(new Pair<Class<? extends IEffect>, Object>(hostInterface, null));
            if (!singleToMultiConverters.containsKey(hostInterface)) continue;
            Pair<Class<? extends IEffect>, Class<? extends McFromScBase<?, ?>>> pair = singleToMultiConverters.get(hostInterface);
            targetInterfaces.add(pair);
        }
        Properties properties = PluginsImpl.loadProperties(effectType);
        Class mtEffectInterface = null;
        MultiThreading mtAnno = AnnotationUtils.getAnnotation(effectType, MultiThreading.class, properties);
        if (PluginsImpl.isMultiThreadingSupported(mtAnno, mtContext)) {
            boolean hostPullOk;
            boolean hostPushOk;
            if (effectInterface.equals(ISimpleEffect.class)) {
                hostPushOk = false;
                hostPullOk = false;
                for (Pair pair : targetInterfaces) {
                    Class clazz = (Class)pair.getFirst();
                    if (clazz.equals(ISingleChanPushEffect.class)) {
                        hostPushOk = true;
                    }
                    if (!clazz.equals(ISingleChanPullEffect.class)) continue;
                    hostPullOk = true;
                }
                if (hostPushOk) {
                    mtEffectInterface = ch.tachyon.tunnel.plugin.IPushEffect.class;
                } else if (hostPullOk) {
                    mtEffectInterface = IPullEffect.class;
                }
            }
            if (effectInterface.equals(IMultiChanEffect.class)) {
                hostPushOk = false;
                hostPullOk = false;
                for (Pair pair : targetInterfaces) {
                    Class clazz = (Class)pair.getFirst();
                    if (clazz.equals(IPushEffect.class)) {
                        hostPushOk = true;
                    }
                    if (!clazz.equals(ch.tachyon.tunnel.host.effect.IPullEffect.class)) continue;
                    hostPullOk = true;
                }
                if (hostPushOk) {
                    mtEffectInterface = IMultiChanPushEffect.class;
                } else if (hostPullOk) {
                    mtEffectInterface = IMultiChanPullEffect.class;
                }
            }
        }
        boolean isMultiThreadable = mtEffectInterface != null;
        Pair<Class, Class> bestConversion = null;
        Object var10_16 = null;
        int bestPriority = Integer.MAX_VALUE;
        for (Pair pair : targetInterfaces) {
            Class<? extends IEffect> converterType;
            int priority;
            Class hostInterface = (Class)pair.getFirst();
            boolean isParallelizingChans = pair.getSecond() != null;
            boolean isWorthMultithreading = !isParallelizingChans || mtContext.getNbThreads() > 2;
            Class pluginInterface = isWorthMultithreading && isMultiThreadable ? mtEffectInterface : effectInterface;
            ConversionInfo conversionInfo = new ConversionInfo(pluginInterface, hostInterface, (Class)pair.getSecond(), isWorthMultithreading);
            Pair<Class, Class> conversion = new Pair<Class, Class>(pluginInterface, hostInterface);
            if (!bridges.containsKey(conversion) || (priority = bridgePriorities.get(converterType = bridges.get(conversion)).intValue()) >= bestPriority) continue;
            bestConversion = conversion;
            ConversionInfo conversionInfo2 = conversionInfo;
            bestPriority = priority;
        }
        if (bestConversion == null) {
            return null;
        }
        IPlugin iPlugin = effectType.newInstance();
        final Class<? extends IEffect> converterType = bridges.get(bestConversion);
        final boolean isMultiThreadingWorth = var10_17.isWorthMultiThreading;
        McFromScBase<?, ?> converted = bridged = PluginsImpl.newConverter(converterType, var10_17.pluginInterface, iPlugin, properties, mtAnno, mtContext, isMultiThreadingWorth);
        if (var10_17.chanConverterType != null) {
            McFromScBase<?, ?> chanConverter = var10_17.chanConverterType.newInstance();
            final Class<? extends IPlugin> effectInterface0 = var10_17.pluginInterface;
            final Properties properties0 = properties;
            final MultiThreading mtAnno0 = mtAnno;
            final MtContext mtContext0 = mtContext;
            chanConverter.init(bridged, new IScEffectFactory<IEffect>(){

                @Override
                public IEffect create(IEffect mainEffect, IProcessingInfo info) {
                    try {
                        IPlugin plugin = (IPlugin)effectType.newInstance();
                        return PluginsImpl.newConverter(converterType, effectInterface0, plugin, properties0, mtAnno0, mtContext0, isMultiThreadingWorth);
                    }
                    catch (IllegalAccessException ex) {
                        throw new RuntimeException(ex);
                    }
                    catch (InstantiationException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            });
            converted = chanConverter;
        }
        return converted;
    }

    private static List<Class<? extends IPlugin>> getEffectInterfaces(Class<? extends IPlugin> effectType) {
        ArrayList<Class<? extends IPlugin>> result = new ArrayList<Class<? extends IPlugin>>();
        Class<? extends IPlugin> currentType = effectType;
        do {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = currentType.getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> intf = classArray[n2];
                if (PluginsImpl.interfaceExtends(intf, IPlugin.class)) {
                    Class<?> pluginIntf = intf;
                    result.add(pluginIntf);
                }
                ++n2;
            }
        } while ((currentType = currentType.getSuperclass()) != null);
        return result;
    }

    private static boolean interfaceExtends(Class<?> intf, Class<?> parent) {
        Class<?>[] parents;
        Class<?>[] classArray = parents = intf.getInterfaces();
        int n = parents.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> p = classArray[n2];
            if (p.equals(parent)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static <H extends IEffect, P extends IPlugin> H newConverter(Class<H> converterType, Class<P> targetType, IPlugin target, Properties properties, MultiThreading mtSpecs, MtContext mtContext, boolean isMultiThreadingWorth) {
        IPlugin processingTarget = target;
        try {
            if (isMultiThreadingWorth && PluginsImpl.isMultiThreadingSupported(mtSpecs, mtContext)) {
                if (processingTarget instanceof ISimpleEffect && targetType.equals(ch.tachyon.tunnel.plugin.IPushEffect.class)) {
                    processingTarget = new BridgeScSimpleAsPush((ISimpleEffect)processingTarget);
                }
                if (processingTarget instanceof ISimpleEffect && targetType.equals(IPullEffect.class)) {
                    processingTarget = new BridgeScSimpleAsPull((ISimpleEffect)processingTarget);
                }
                if (processingTarget instanceof IMultiChanEffect && targetType.equals(IMultiChanPushEffect.class)) {
                    processingTarget = new BridgeMcSimpleAsPush((IMultiChanEffect)processingTarget);
                }
                if (processingTarget instanceof IMultiChanEffect && targetType.equals(IMultiChanPullEffect.class)) {
                    processingTarget = new BridgeMcSimpleAsPull((IMultiChanEffect)processingTarget);
                }
                if (processingTarget instanceof ch.tachyon.tunnel.plugin.IPushEffect) {
                    processingTarget = new MtScPush((ch.tachyon.tunnel.plugin.IPushEffect)processingTarget, mtContext);
                } else if (processingTarget instanceof IPullEffect) {
                    processingTarget = new MtScPull((IPullEffect)processingTarget, mtContext);
                } else if (processingTarget instanceof IMultiChanPushEffect) {
                    processingTarget = new MtMcPush((IMultiChanPushEffect)processingTarget, mtContext);
                } else if (processingTarget instanceof IMultiChanPullEffect) {
                    processingTarget = new MtMcPull((IMultiChanPullEffect)processingTarget, mtContext);
                }
            }
            IEffect result = (IEffect)converterType.newInstance();
            PluginToHostWrapper wrapper = (PluginToHostWrapper)result;
            wrapper.init(target, processingTarget, mtContext, properties);
            return (H)result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private static boolean isMultiThreadingSupported(MultiThreading mtAnno, MtContext mtContext) {
        boolean result;
        boolean bl = result = mtAnno != null && !mtAnno.markov();
        if (!mtContext.isMultiCore()) {
            result = false;
        }
        return result;
    }

    public static <I extends IEffect, E extends IPlugin> I getPlugin(Class<I> commIntf, Class<E> pluginClass, MtContext mtContext) {
        ArrayList<Class<? extends IEffect>> singleton = new ArrayList<Class<? extends IEffect>>(1);
        singleton.add(commIntf);
        try {
            IEffect result = PluginsImpl.createEffect(singleton, pluginClass, mtContext);
            return (I)result;
        }
        catch (IllegalAccessException ex) {
            throw new IllegalAccessError(ex.toString());
        }
        catch (InstantiationException ex) {
            throw new InstantiationError(ex.toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConversionInfo {
        Class<? extends IPlugin> pluginInterface;
        Class<? extends IEffect> targetInterface;
        Class<? extends McFromScBase<?, ?>> chanConverterType;
        boolean isWorthMultiThreading;

        public ConversionInfo(Class<? extends IPlugin> pluginInterface, Class<? extends IEffect> targetInterface, Class<? extends McFromScBase<?, ?>> converterType, boolean isWorthMultiThreading) {
            this.pluginInterface = pluginInterface;
            this.targetInterface = targetInterface;
            this.chanConverterType = converterType;
            this.isWorthMultiThreading = isWorthMultiThreading;
        }
    }
}

