/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IPullEffect;
import ch.tachyon.tunnel.plugin.IMultiChanPullEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Arrays;
import java.util.Properties;
import javax.sound.sampled.AudioFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McPullFromMcPull
extends PluginToHostWrapper<IMultiChanPullEffect>
implements IPullEffect,
IMultiChanAudioSource {
    private IMultiChanPullEffect wrappedTarget;
    private IMultiChanAudioSource curSource;
    private int headOutToSkip;
    private int tailInToPad;
    private int maxOutputLength;

    @Override
    public void init(IPlugin baseTarget, IPlugin processingTarget, IMtContext mtContext, Properties properties) {
        super.init(baseTarget, (IMultiChanPullEffect)processingTarget, IPullEffect.class, mtContext, properties);
    }

    private int getChunkLength(IProcessingInfo info) {
        int result = this.getPreferredChunkLength();
        if (result > 0) {
            return result;
        }
        result = info.getHostPreferredChunkLength();
        if (result > 0) {
            return result;
        }
        return 2048;
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.headOutToSkip = super.getLatency(IoDirection.OUTPUT);
        this.tailInToPad = super.getLatency(IoDirection.INPUT);
        this.maxOutputLength = this.getActualMaxChunkLength(info);
        this.wrappedTarget = super.needsRebuffering() || this.headOutToSkip > 0 ? new IMultiChanPullEffect(info){
            private final float[][] buffer;
            private int bufferIndex;
            private int bufferAvailable;
            {
                this.buffer = new float[iProcessingInfo.getNumberOfChannels()][McPullFromMcPull.this.getChunkLength(iProcessingInfo)];
                this.bufferIndex = this.buffer[0].length;
            }

            public int process(IMultiChanAudioSource source, float[][] output) {
                int outIndex = 0;
                int result = 0;
                while (outIndex < output[0].length) {
                    if (this.bufferIndex >= this.buffer[0].length) {
                        this.bufferAvailable = ((IMultiChanPullEffect)McPullFromMcPull.this.processingTarget).process(source, this.buffer);
                        this.bufferIndex = 0;
                    }
                    int amount = Math.min(output[0].length - outIndex, this.buffer[0].length - this.bufferIndex);
                    int chan = 0;
                    while (chan < output.length) {
                        System.arraycopy(this.buffer[chan], this.bufferIndex, output[chan], outIndex, amount);
                        ++chan;
                    }
                    result += Math.max(0, Math.min(amount, this.bufferAvailable - this.bufferIndex));
                    outIndex += amount;
                    this.bufferIndex += amount;
                }
                return result;
            }

            public boolean canWriteFasterThanRead() {
                return ((IMultiChanPullEffect)McPullFromMcPull.this.processingTarget).canWriteFasterThanRead();
            }
        } : (IMultiChanPullEffect)this.processingTarget;
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IMultiChanPullEffect)this.processingTarget).canWriteFasterThanRead();
    }

    @Override
    public int process(IMultiChanAudioSource source, float[][] output) {
        this.beginIfWorth();
        if (output[0].length > this.maxOutputLength) {
            throw new IllegalArgumentException("Host error: the given array length is greater than the maximum length specified by the IProcessingInfo object passed to startProcessing()");
        }
        this.curSource = source;
        if (this.headOutToSkip > 0) {
            float[][] temp = new float[output.length][this.headOutToSkip];
            this.wrappedTarget.process(this, temp);
            this.headOutToSkip = 0;
        }
        int result = this.wrappedTarget.process(this, output);
        assert (this.isSane(output, false));
        return result;
    }

    @Override
    public int readSamples(float[][] target) {
        int result = this.curSource.readSamples(target);
        if (result < target[0].length && this.tailInToPad > 0) {
            int amount = Math.min(target[0].length - result, this.tailInToPad);
            int chan = 0;
            while (chan < target.length) {
                Arrays.fill(target[chan], result, result + amount, 0.0f);
                ++chan;
            }
            this.tailInToPad -= amount;
            result += amount;
        }
        assert (this.isSane(target, true));
        super.processed(result);
        return result;
    }

    @Override
    public AudioFormat getAudioFormat() {
        return this.curSource.getAudioFormat();
    }
}

