/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges;

import ch.tachyon.tunnel.common.ISingleChanAudioSink;
import ch.tachyon.tunnel.common.IoDirection;
import ch.tachyon.tunnel.engine.PluginToHostWrapper;
import ch.tachyon.tunnel.engine.utils.Rebufferizer;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.ISingleChanPushEffect;
import ch.tachyon.tunnel.plugin.IPlugin;
import ch.tachyon.tunnel.plugin.IPushEffect;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import java.util.Arrays;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScPushFromScPush
extends PluginToHostWrapper<IPushEffect>
implements ISingleChanPushEffect,
ISingleChanAudioSink {
    private ISingleChanAudioSink curSink;
    private Rebufferizer rebufferizer = null;
    private int queued;
    private int headOutToSkip;
    private int tailInToPad;
    private int maxInputLength;
    private boolean lastChunkRecieved;

    @Override
    public void init(IPlugin baseTarget, IPlugin processingTarget, IMtContext mtContext, Properties properties) {
        super.init(baseTarget, (IPushEffect)processingTarget, ISingleChanPushEffect.class, mtContext, properties);
    }

    @Override
    public boolean canWriteFasterThanRead() {
        return ((IPushEffect)this.processingTarget).canWriteFasterThanRead();
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.headOutToSkip = super.getLatency(IoDirection.OUTPUT);
        this.tailInToPad = super.getLatency(IoDirection.INPUT);
        info.negociateFixedChunkLength(this.getActualChunkLength());
        this.maxInputLength = this.getActualMaxChunkLength(info);
        this.rebufferizer = super.needsRebuffering() ? new Rebufferizer(this.maxInputLength, this.getActualChunkLength()) : null;
        this.queued = 0;
        this.lastChunkRecieved = false;
    }

    @Override
    public void process(float[] input, int length, ISingleChanAudioSink sink) {
        this.beginIfWorth();
        assert (super.isSane(input, true));
        if (length > this.maxInputLength) {
            throw new IllegalArgumentException("Host error: the given length is greater than the maximum length specified by the IProcessingInfo object passed to startProcessing()");
        }
        if (this.lastChunkRecieved) {
            throw new IllegalArgumentException("process() was already invoked with a length less than the array length, meaning that it was the last block. No further call to process() shall be done. Perhaps you mean to invoke stopProcessing() and startProcessing() to start a new audio chunk");
        }
        this.curSink = sink;
        if (length == input.length) {
            if (this.rebufferizer == null) {
                input = super.wrapInput(input);
                ((IPushEffect)this.processingTarget).process(input, length, this);
            } else {
                this.rebufferizer.submitVariable(input);
                this.queued += length;
                float[] fixed = this.rebufferizer.retrieveFixed();
                while (fixed != null) {
                    this.queued -= fixed.length;
                    fixed = super.wrapInput(fixed);
                    ((IPushEffect)this.processingTarget).process(fixed, fixed.length, this);
                    fixed = this.rebufferizer.retrieveFixed();
                }
            }
        } else {
            this.lastChunkRecieved = true;
            int remaining = length + this.tailInToPad + this.queued;
            boolean lastSent = false;
            while (remaining > 0) {
                Arrays.fill(input, length, input.length, 0.0f);
                if (this.rebufferizer == null) {
                    int amount = Math.min(remaining, (input = super.wrapInput(input)).length);
                    if (amount < input.length) {
                        lastSent = true;
                    }
                    ((IPushEffect)this.processingTarget).process(input, amount, this);
                    length = Math.max(0, length - amount);
                    remaining -= amount;
                    continue;
                }
                this.rebufferizer.submitVariable(input);
                float[] fixed = this.rebufferizer.retrieveFixed();
                while (fixed != null && remaining > 0) {
                    int amount = Math.min(remaining, (fixed = super.wrapInput(fixed)).length);
                    if (amount < fixed.length) {
                        lastSent = true;
                    }
                    ((IPushEffect)this.processingTarget).process(fixed, amount, this);
                    fixed = this.rebufferizer.retrieveFixed();
                    length = Math.max(0, length - amount);
                    remaining -= amount;
                }
            }
            if (!lastSent) {
                if (this.rebufferizer != null) {
                    float[] last = new float[this.rebufferizer.getTargetSize()];
                    ((IPushEffect)this.processingTarget).process(last, 0, this);
                } else {
                    float[] last = new float[input.length];
                    ((IPushEffect)this.processingTarget).process(last, 0, this);
                }
            }
            this.tailInToPad = 0;
        }
        super.processed(length);
    }

    @Override
    public void stopProcessing() {
        super.stopProcessing();
        this.curSink = null;
    }

    @Override
    public void writeSamples(float[] samples) {
        assert (super.isSane(samples, false));
        int amount = samples.length;
        if (this.headOutToSkip >= amount) {
            this.headOutToSkip -= amount;
        } else if (this.headOutToSkip > 0) {
            float[] head = new float[amount - this.headOutToSkip];
            System.arraycopy(samples, this.headOutToSkip, head, 0, head.length);
            this.curSink.writeSamples(head);
            this.headOutToSkip = 0;
        } else {
            this.curSink.writeSamples(samples);
        }
    }
}

