/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.chan;

import ch.tachyon.tunnel.engine.bridges.chan.McFromScBase;
import ch.tachyon.tunnel.engine.utils.concurrent.Task;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IEffect;
import ch.tachyon.tunnel.host.effect.ISimpleEffect;
import ch.tachyon.tunnel.host.effect.ISingleChanEffect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class McEffectFromScEffect
extends McFromScBase<ISimpleEffect, ISingleChanEffect>
implements ISimpleEffect {
    private ProcessOnChanTask[] tasks;

    @Override
    public Class<? extends IEffect> getInterface() {
        return ISimpleEffect.class;
    }

    @Override
    public int getLatency() {
        return ((ISingleChanEffect)this.descTarget).getLatency();
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        super.startProcessing(info);
        this.tasks = new ProcessOnChanTask[this.nbChans];
        int chan = 0;
        while (chan < this.nbChans) {
            this.tasks[chan] = new ProcessOnChanTask(chan);
            ++chan;
        }
    }

    @Override
    public void process(float[][] samples) {
        if (samples.length != this.nbChans) {
            throw new IllegalArgumentException("Wrong number of channels. Found samples.length = " + samples.length + ", excpected: " + this.nbChans);
        }
        assert (this.targets.size() == this.nbChans);
        super.preProcessMidSide(samples);
        int nbFrames = 0;
        int chan = 0;
        while (chan < this.nbChans) {
            if (chan == 0) {
                nbFrames = samples[chan].length;
            } else if (nbFrames != samples[chan].length) {
                throw new IllegalArgumentException("Number of samples is not the same in all channels, Channel 0 has " + nbFrames + " samples and channel " + chan + " has " + samples[chan].length);
            }
            this.tasks[chan].setup(samples[chan]);
            ++chan;
        }
        if (this.pool != null) {
            this.pool.executeAndWait(this.tasks);
        } else {
            ProcessOnChanTask[] processOnChanTaskArray = this.tasks;
            int n = this.tasks.length;
            int n2 = 0;
            while (n2 < n) {
                ProcessOnChanTask task = processOnChanTaskArray[n2];
                ((Task)task).run();
                ++n2;
            }
        }
        super.postProcessMidSide(samples);
    }

    @Override
    public void stopProcessing() {
        super.stopProcessing();
        this.tasks = null;
    }

    class ProcessOnChanTask
    extends Task {
        private final int chan;
        private float[] input;

        public ProcessOnChanTask(int chan) {
            this.chan = chan;
        }

        void setup(float[] input) {
            this.input = input;
        }

        public void run() {
            ((ISingleChanEffect)McEffectFromScEffect.this.targets.get(this.chan)).process(this.input);
        }
    }
}

