/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.chan;

import ch.tachyon.tunnel.common.ParameterDefinition;
import ch.tachyon.tunnel.engine.bridges.chan.IScEffectFactory;
import ch.tachyon.tunnel.engine.bridges.chan.OneChanProcessingInfo;
import ch.tachyon.tunnel.engine.bridges.mthread.MtContext;
import ch.tachyon.tunnel.engine.utils.concurrent.ThreadPool;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IEffect;
import ch.tachyon.tunnel.host.effect.IGuiListener;
import ch.tachyon.tunnel.host.effect.IParameter;
import ch.tachyon.tunnel.plugin.opt.spec.MidSide;
import java.io.Reader;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class McFromScBase<MC extends IEffect, SC extends IEffect>
implements IEffect {
    protected ThreadPool pool;
    protected SC descTarget;
    private IScEffectFactory<SC> scFactory;
    protected int nbChans;
    protected List<SC> targets;
    private boolean midSide;

    public void init(SC descTarget, IScEffectFactory<SC> scFactory) {
        this.descTarget = descTarget;
        this.scFactory = scFactory;
        this.midSide = descTarget.getAnnotation(MidSide.class) != null;
    }

    protected void preProcessMidSide(float[][] data) {
        if (!this.midSide || data.length < 2) {
            return;
        }
        if (data.length == 2) {
            float[] left = data[0];
            float[] right = data[1];
            this.preProcessStereo(left, right);
        } else {
            int nbChans = data.length;
            int i = 0;
            while (i < nbChans - 1) {
                this.preProcessStereo(data[i], data[i + 1]);
                i += 2;
            }
            i = 0;
            while (i < nbChans - 2) {
                this.preProcessStereo(data[i], data[i + 2]);
                ++i;
            }
        }
    }

    private void preProcessStereo(float[] left, float[] right) {
        assert (left.length == right.length);
        int i = 0;
        while (i < left.length) {
            float l = left[i];
            float r = right[i];
            left[i] = (l + r) / 2.0f;
            right[i] = (l - r) / 2.0f;
            ++i;
        }
    }

    protected void postProcessMidSide(float[][] data) {
        if (!this.midSide || data.length < 2) {
            return;
        }
        if (data.length == 2) {
            float[] left = data[0];
            float[] right = data[1];
            this.postProcessStereo(left, right);
        } else {
            int nbChans = data.length;
            int i = nbChans - 3;
            while (i >= 0) {
                this.postProcessStereo(data[i], data[i + 2]);
                --i;
            }
            i = 0;
            while (i < nbChans - 1) {
                this.postProcessStereo(data[i], data[i + 1]);
                i += 2;
            }
        }
    }

    private void postProcessStereo(float[] left, float[] right) {
        assert (left.length == right.length);
        int i = 0;
        while (i < left.length) {
            float m = left[i];
            float s = right[i];
            left[i] = m + s;
            right[i] = m - s;
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.descTarget.getName();
    }

    @Override
    public String getCategory() {
        return this.descTarget.getCategory();
    }

    @Override
    public String getClassName() {
        return this.descTarget.getClassName();
    }

    @Override
    public abstract Class<? extends IEffect> getInterface();

    @Override
    public List<IParameter> getParameters() {
        return this.descTarget.getParameters();
    }

    @Override
    public String getDescription() {
        return this.descTarget.getDescription();
    }

    @Override
    public Reader getDocumentation() {
        return this.descTarget.getDocumentation();
    }

    @Override
    public <E extends Annotation> E getAnnotation(Class<E> annoType) {
        return this.descTarget.getAnnotation(annoType);
    }

    private static IProcessingInfo wrap(IProcessingInfo info, int chanIndex) {
        return new OneChanProcessingInfo(info, chanIndex, info.getNumberOfChannels());
    }

    @Override
    public void load(IProcessingInfo info) {
        this.descTarget.load(McFromScBase.wrap(info, 0));
        this.nbChans = info.getNumberOfChannels();
        if (this.nbChans <= 0) {
            throw new IllegalArgumentException("Invalid number of channels: " + this.nbChans);
        }
        this.targets = new ArrayList<SC>(this.nbChans);
        this.targets.add(this.descTarget);
        int chan = 1;
        while (chan < this.nbChans) {
            SC chanTarget = this.scFactory.create(this.descTarget, info);
            chanTarget.load(McFromScBase.wrap(info, chan));
            this.targets.add(chanTarget);
            ++chan;
        }
    }

    @Override
    public JPanel createControlPanel() {
        return this.descTarget.createControlPanel();
    }

    @Override
    public void showGui(JFrame parent, IGuiListener listener) {
        this.descTarget.showGui(parent, listener);
    }

    @Override
    public void hideGui() {
        this.descTarget.hideGui();
    }

    @Override
    public <P, T> void setParameterValue(ParameterDefinition<P, T> parameter, T value) {
        for (IEffect target : this.targets) {
            target.setParameterValue(parameter, value);
        }
    }

    @Override
    public <P, T> T getParameterValue(ParameterDefinition<P, T> parameter) {
        return this.descTarget.getParameterValue(parameter);
    }

    @Override
    public void setParameterValue(String name, Object value) {
        for (IEffect target : this.targets) {
            target.setParameterValue(name, value);
        }
    }

    @Override
    public Object getParameterValue(String name) {
        return this.descTarget.getParameterValue(name);
    }

    @Override
    public int getPreferredChunkLength() {
        return this.descTarget.getPreferredChunkLength();
    }

    @Override
    public void startProcessing(IProcessingInfo info) {
        int chan = 1;
        while (chan < this.nbChans) {
            IEffect chanTarget = (IEffect)this.targets.get(chan);
            List<IParameter> srcParameters = this.descTarget.getParameters();
            List<IParameter> dstParameters = chanTarget.getParameters();
            assert (srcParameters.size() == dstParameters.size()) : "Target and its copy do not have the same number of parameters";
            int i = 0;
            while (i < srcParameters.size()) {
                assert (srcParameters.get(i).getName().equals(dstParameters.get(i).getName())) : "Target parameters do not match copy parameters";
                dstParameters.get(i).setInternalValue(srcParameters.get(i).getInternalValue());
                ++i;
            }
            ++chan;
        }
        chan = 0;
        while (chan < this.nbChans) {
            ((IEffect)this.targets.get(chan)).startProcessing(McFromScBase.wrap(info, chan));
            ++chan;
        }
        MtContext mtContext = new MtContext();
        if (mtContext.getNbThreads() > 1 && this.nbChans > 1) {
            this.pool = new ThreadPool("Channel", Math.min(this.nbChans, mtContext.getNbThreads()));
        }
    }

    @Override
    public long getAdditionalInputFrames() {
        return this.descTarget.getAdditionalInputFrames();
    }

    @Override
    public boolean requiresSamplesBeforeOrAfter() {
        return this.descTarget.requiresSamplesBeforeOrAfter();
    }

    @Override
    public long getRequiredSamplesBefore() {
        return this.descTarget.getRequiredSamplesBefore();
    }

    @Override
    public long getRequiredSamplesAfter() {
        return this.descTarget.getRequiredSamplesAfter();
    }

    @Override
    public float getTimeChange() {
        return this.descTarget.getTimeChange();
    }

    @Override
    public long getProcessedFrames() {
        return this.descTarget.getProcessedFrames();
    }

    @Override
    public void stopProcessing() {
        for (IEffect target : this.targets) {
            target.stopProcessing();
        }
        if (this.pool != null) {
            this.pool.dispose();
        }
        this.pool = null;
    }

    @Override
    public void unload() {
        for (IEffect target : this.targets) {
            target.unload();
        }
        this.targets = null;
        this.nbChans = 0;
    }
}

