/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClockedAsynchronousQueue<E> {
    private final int capacity;
    private final AtomicReferenceArray<E> buffers;
    private final AtomicReferenceArray<Thread> parkedProducers;
    private final AtomicReferenceArray<Thread> parkedConsumers;
    private volatile boolean active = true;

    public ClockedAsynchronousQueue(int capacity) {
        this.capacity = capacity;
        this.buffers = new AtomicReferenceArray(capacity);
        this.parkedProducers = new AtomicReferenceArray(capacity);
        this.parkedConsumers = new AtomicReferenceArray(capacity);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(long clock, E element) {
        if (!this.active) {
            return;
        }
        int index = (int)(clock % (long)this.capacity);
        try {
            if (this.buffers.compareAndSet(index, null, element)) {
                return;
            }
            boolean success = this.parkedProducers.compareAndSet(index, null, Thread.currentThread());
            assert (success);
            while (true) {
                if (this.buffers.compareAndSet(index, null, element)) {
                    this.parkedProducers.set(index, null);
                    return;
                }
                this.park();
            }
        }
        catch (InterruptedException ex) {
            return;
        }
        finally {
            Thread waiting = this.parkedConsumers.get(index);
            if (waiting != null) {
                LockSupport.unpark(waiting);
            }
        }
    }

    public E take(long clock) {
        if (!this.active) {
            return null;
        }
        int index = (int)(clock % (long)this.capacity);
        try {
            E result = this.buffers.getAndSet(index, null);
            if (result != null) {
                E e = result;
                return e;
            }
            boolean success = this.parkedConsumers.compareAndSet(index, null, Thread.currentThread());
            assert (success);
            result = this.buffers.getAndSet(index, null);
            while (result == null) {
                this.park();
                result = this.buffers.getAndSet(index, null);
            }
            this.parkedConsumers.set(index, null);
            E e = result;
            return e;
        }
        catch (InterruptedException ex) {
            return null;
        }
        finally {
            Thread waiting = this.parkedProducers.get(index);
            if (waiting != null) {
                LockSupport.unpark(waiting);
            }
        }
    }

    public E poll(long clock) {
        Thread waiting;
        int index = (int)(clock % (long)this.capacity);
        E result = this.buffers.getAndSet(index, null);
        if (result != null && (waiting = this.parkedProducers.get(index)) != null) {
            LockSupport.unpark(waiting);
        }
        return result;
    }

    private void park() throws InterruptedException {
        if (!this.active) {
            throw new InterruptedException();
        }
        LockSupport.park();
    }

    public void dispose() {
        this.active = false;
        int i = 0;
        while (i < this.capacity) {
            Thread t = this.parkedConsumers.get(i);
            if (t != null) {
                LockSupport.unpark(t);
            }
            if ((t = this.parkedProducers.get(i)) != null) {
                LockSupport.unpark(t);
            }
            ++i;
        }
    }
}

