/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread;

import ch.tachyon.tunnel.engine.utils.concurrent.ThreadPool;
import ch.tachyon.tunnel.plugin.opt.thread.IMtContext;
import ch.tachyon.tunnel.utils.Debug;
import java.util.HashMap;
import java.util.Map;

public class MtContext
implements IMtContext {
    private static final String NB_THREADS_PROPERTY = "ch.tachyon.tunnel.threads";
    private int nbThreads;
    private int defaultNbThreads;
    private Map<Object, ThreadPool> pools = new HashMap<Object, ThreadPool>();

    synchronized ThreadPool setupPool(Object owner, int chanDivider) {
        ThreadPool pool = this.pools.get(owner);
        if (pool == null) {
            int nbThreads = this.getNbThreads();
            if (chanDivider > 1) {
                nbThreads = Math.max(1, (nbThreads + chanDivider - 1) / chanDivider);
            }
            pool = new ThreadPool("Processing", nbThreads);
            this.pools.put(owner, pool);
        }
        return pool;
    }

    synchronized void releasePool(Object owner) {
        ThreadPool pool = this.pools.remove(owner);
        if (pool != null) {
            pool.dispose();
        }
    }

    public int getMaxNbThreads() {
        return this.getNbThreads();
    }

    public synchronized ThreadPool getThreadPool(Object owner) {
        return this.pools.get(owner);
    }

    public int getNbThreads() {
        if (this.nbThreads <= 0) {
            if (this.defaultNbThreads < 1) {
                String prop = System.getProperty(NB_THREADS_PROPERTY);
                if (prop != null) {
                    try {
                        int result = Integer.parseInt(prop);
                        if (result >= 1) {
                            this.defaultNbThreads = result;
                            Debug.info("Using {0} threads", result);
                        }
                    }
                    catch (NumberFormatException ex) {
                        Debug.warn("Illegal value for property ch.tachyon.tunnel.threads: {0}", prop);
                    }
                }
                if (this.defaultNbThreads < 1) {
                    this.defaultNbThreads = Runtime.getRuntime().availableProcessors();
                    long maxMemMb = (Runtime.getRuntime().maxMemory() >> 20) - 96L;
                    int maxSupportedCores = (int)Math.max(1L, maxMemMb / 10L);
                    if (this.defaultNbThreads > maxSupportedCores) {
                        Debug.warn("Using only {0} of {1} cores as the allocated memory is limited", maxSupportedCores, this.defaultNbThreads);
                        this.defaultNbThreads = maxSupportedCores;
                    }
                }
            }
            return this.defaultNbThreads;
        }
        return this.nbThreads;
    }

    public boolean isMultiCore() {
        return this.getNbThreads() > 1;
    }

    public void setNbThreads(int nbThreads) {
        if (!this.pools.isEmpty()) {
            throw new IllegalStateException("Cannot change the number of threads while a pool is in use");
        }
        this.nbThreads = nbThreads;
    }

    public int getSerialRunningMaxSkew() {
        return this.getNbThreads();
    }

    public int getSerialTotalMaxSkew() {
        int nbThreads = this.getNbThreads();
        return nbThreads + ThreadPool.getDefaultQueueSize(nbThreads);
    }
}

