/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread.serial;

import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.engine.utils.concurrent.ThreadPool;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.LockSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfiledSerialSection
implements ISerialSectionExt {
    private final ThreadPool threadPool;
    private AtomicLong clock = new AtomicLong(0L);
    private final AtomicReference<Thread>[] waiters;
    private final int queueSize;
    private final long mask;
    protected final ThreadLocal<Long> threadClocks = new ThreadLocal();
    protected final String name;
    protected final Object userData;
    private AtomicLong waitTime = new AtomicLong(0L);
    private AtomicLong enterTime = new AtomicLong(0L);
    private AtomicLong leaveTime = new AtomicLong(0L);
    private AtomicLong blockedTime = new AtomicLong(0L);
    private AtomicLong serialTime = new AtomicLong(0L);
    private AtomicLong parallelTime = new AtomicLong(0L);
    private ThreadLocal<Long> lastTime = new ThreadLocal<Long>(){

        @Override
        protected Long initialValue() {
            return System.nanoTime();
        }
    };
    private long counter = 0L;
    public static long resyncTime;
    public static long scheduleTime;

    public ProfiledSerialSection(ThreadPool threadPool, String name, Object userData) {
        this.threadPool = threadPool;
        this.name = name;
        this.userData = userData;
        int poolSize = threadPool.getPoolSize();
        int qs = 1;
        while (qs < poolSize) {
            qs *= 2;
        }
        this.queueSize = qs;
        this.mask = qs - 1;
        this.waiters = new AtomicReference[this.queueSize];
        int i = 0;
        while (i < this.waiters.length) {
            this.waiters[i] = new AtomicReference<Object>(null);
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public <E> E getUserData(Class<E> expectedType) {
        if (this.userData == null) {
            return null;
        }
        if (expectedType.isInstance(this.userData)) {
            return (E)this.userData;
        }
        throw new ClassCastException("Cannopt cast " + this.userData.getClass() + " to " + expectedType);
    }

    @Override
    public void setActive(boolean value) {
        long time = System.nanoTime();
        if (value) {
            this.waitTime.addAndGet(time - this.lastTime.get());
        } else {
            this.parallelTime.addAndGet(time - this.lastTime.get());
        }
        this.lastTime.set(time);
    }

    @Override
    public void enterSerialSection() {
        long time1 = System.nanoTime();
        this.parallelTime.addAndGet(time1 - this.lastTime.get());
        long threadClock = this.threadClocks.get();
        int index = (int)(threadClock & this.mask);
        this.waiters[index].set(Thread.currentThread());
        while (threadClock != this.clock.get()) {
            long timeW = System.nanoTime();
            this.enterTime.addAndGet(timeW - time1);
            LockSupport.park();
            time1 = System.nanoTime();
            this.blockedTime.addAndGet(time1 - timeW);
        }
        ++this.counter;
        this.waiters[index].set(null);
        long time2 = System.nanoTime();
        this.enterTime.addAndGet(time2 - time1);
        this.lastTime.set(time2);
    }

    @Override
    public void leaveSerialSection() {
        long time1 = System.nanoTime();
        this.serialTime.addAndGet(time1 - this.lastTime.get());
        long nextClock = this.clock.incrementAndGet();
        int index = (int)(nextClock & this.mask);
        Thread next = this.waiters[index].get();
        if (next != null) {
            LockSupport.unpark(next);
        }
        this.threadClocks.set(this.threadClocks.get() + 1L);
        long time2 = System.nanoTime();
        this.leaveTime.addAndGet(time2 - time1);
        this.lastTime.set(time2);
    }

    @Override
    public void sync() {
        this.enterSerialSection();
        this.leaveSerialSection();
    }

    @Override
    public long getClock() {
        return this.threadClocks.get();
    }

    @Override
    public void setClock(long clock) {
        this.threadClocks.set(clock);
    }

    @Override
    public synchronized void clearClock() {
        this.threadClocks.remove();
        if (this.counter != 0L) {
            int nbThreads = Math.min(Runtime.getRuntime().availableProcessors(), this.threadPool.getPoolSize());
            this.parallelTime.set(this.parallelTime.get() / (long)nbThreads);
            this.enterTime.set(this.enterTime.get() / (long)nbThreads);
            this.leaveTime.set(this.leaveTime.get() / (long)nbThreads);
            this.blockedTime.set(this.blockedTime.get() / (long)nbThreads);
            this.serialTime.set(this.serialTime.get() / (long)nbThreads);
            this.waitTime.set(this.waitTime.get() / (long)nbThreads);
            System.out.println("SerialSection \"" + this.name + "\" statistics:");
            DecimalFormat formatter = new DecimalFormat("#,##0");
            DecimalFormat ratioFtr = new DecimalFormat("#,##0.00");
            long totalTime = this.parallelTime.get() + this.blockedTime.get() + this.serialTime.get() + this.enterTime.get() + this.leaveTime.get();
            long runningTime = this.parallelTime.get() + this.serialTime.get() + this.enterTime.get() + this.leaveTime.get();
            System.out.println(MessageFormat.format(" Inactive time:  {0}ns ({1}%)", formatter.format(this.waitTime.get() / this.counter), ratioFtr.format((double)this.waitTime.get() * 100.0 / (double)(this.waitTime.get() + totalTime))));
            System.out.println(MessageFormat.format(" Active time:    {0}ns ({1}%)", formatter.format(totalTime / this.counter), ratioFtr.format((double)totalTime * 100.0 / (double)(this.waitTime.get() + totalTime))));
            System.out.println(MessageFormat.format("   Blocked time: {0}ns ({1}%)", formatter.format(this.blockedTime.get() / this.counter), ratioFtr.format((double)this.blockedTime.get() * 100.0 / (double)totalTime)));
            System.out.println(MessageFormat.format("   Outside time: {0}ns ({1}%)", formatter.format((this.parallelTime.get() + this.enterTime.get()) / this.counter), ratioFtr.format((double)(this.parallelTime.get() + this.enterTime.get()) * 100.0 / (double)totalTime)));
            System.out.println(MessageFormat.format("     Enter time: {0}ns ({1}%)", formatter.format(this.enterTime.get() / this.counter), ratioFtr.format((double)this.enterTime.get() * 100.0 / (double)(this.parallelTime.get() + this.enterTime.get()))));
            System.out.println(MessageFormat.format("   Inside time:  {0}ns ({1}%)", formatter.format((this.serialTime.get() + this.leaveTime.get()) / this.counter), ratioFtr.format((double)(this.serialTime.get() + this.leaveTime.get()) * 100.0 / (double)totalTime)));
            System.out.println(MessageFormat.format("     Leave time: {0}ns ({1}%)", formatter.format(this.leaveTime.get() / this.counter), ratioFtr.format((double)this.leaveTime.get() * 100.0 / (double)(this.serialTime.get() + this.leaveTime.get()))));
            System.out.println(MessageFormat.format(" Optimal ratio: {0}", ratioFtr.format((double)runningTime / (double)(this.serialTime.get() + this.enterTime.get() + this.leaveTime.get()))));
            System.out.println(MessageFormat.format(" Actual ratio:  {0}", ratioFtr.format((double)runningTime * (double)nbThreads / (double)totalTime)));
            resyncTime += this.blockedTime.get() * (long)nbThreads;
            scheduleTime += (this.enterTime.get() + this.leaveTime.get()) * (long)nbThreads;
            this.counter = 0L;
        }
    }
}

