/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.bridges.mthread.serial;

import ch.tachyon.tunnel.engine.bridges.mthread.serial.ISerialSectionExt;
import ch.tachyon.tunnel.engine.utils.LongReference;
import ch.tachyon.tunnel.engine.utils.concurrent.SerialSection;
import ch.tachyon.tunnel.engine.utils.concurrent.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SerialSectionImpl
extends SerialSection
implements ISerialSectionExt {
    private final ThreadLocal<LongReference> clock = new ThreadLocal();
    private final String name;
    private final Object userData;

    public SerialSectionImpl(ThreadPool threadPool, String name, Object userData) {
        super(threadPool);
        this.name = name;
        this.userData = userData;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Object getUserData() {
        return this.userData;
    }

    @Override
    public <E> E getUserData(Class<E> expectedType) {
        if (this.userData == null) {
            return null;
        }
        if (expectedType.isInstance(this.userData)) {
            return (E)this.userData;
        }
        throw new ClassCastException("Cannopt cast " + this.userData.getClass() + " to " + expectedType);
    }

    @Override
    public void enterSerialSection() {
        super.enterSerialSection(this.clock.get().get());
    }

    @Override
    public void leaveSerialSection() {
        super.leaveSerialSection();
        LongReference lr = this.clock.get();
        lr.set(lr.get() + 1L);
    }

    @Override
    public void sync() {
        super.sync(this.clock.get().get());
        LongReference lr = this.clock.get();
        lr.set(lr.get() + 1L);
    }

    @Override
    public long getClock() {
        return this.clock.get().get();
    }

    @Override
    public void setClock(long clock) {
        LongReference lr = this.clock.get();
        if (lr == null) {
            lr = new LongReference();
            this.clock.set(lr);
        }
        lr.set(clock);
    }

    @Override
    public void setActive(boolean value) {
    }

    @Override
    public void clearClock() {
        this.clock.remove();
    }
}

