/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.gui;

import ch.tachyon.tunnel.engine.gui.ParameterGuiBuilder;
import ch.tachyon.tunnel.host.effect.IParameter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class BooleanControl
extends JPanel {
    private final IParameter parameter;
    private JCheckBox checkBox;

    public BooleanControl(IParameter parameter) {
        this.parameter = parameter;
        this.setLayout(new BorderLayout());
        this.checkBox = new JCheckBox();
        this.checkBox.setSelected(this.readValue());
        this.add((Component)this.checkBox, "Center");
        if (parameter.getDescription() != null) {
            String tooltip = ParameterGuiBuilder.formatMultiLineAsHtml(parameter.getDescription());
            this.checkBox.setToolTipText(tooltip);
        }
        this.checkBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BooleanControl.this.checkBoxClicked();
            }
        });
    }

    private void checkBoxClicked() {
        this.writeValue(this.checkBox.isSelected());
    }

    public boolean readValue() {
        Object value = this.parameter.getInternalValue();
        return Boolean.TRUE.equals(value);
    }

    public void writeValue(boolean value) {
        this.parameter.setInternalValue(value);
    }
}

