/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.gui;

import ch.tachyon.tunnel.engine.gui.ParameterGuiBuilder;
import ch.tachyon.tunnel.engine.gui.TableLayout;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IEffect;
import ch.tachyon.tunnel.host.effect.IParameter;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class EffectControlPanel
extends JPanel {
    private final double[] WEIGHT_X = new double[]{0.1, 0.7, 0.0};
    private final ParameterGuiBuilder pgBuilder = new ParameterGuiBuilder();
    private final IEffect effect;

    public EffectControlPanel(IEffect effect, IProcessingInfo info) {
        this.effect = effect;
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 21;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 2;
        gbc.insets = new Insets(6, 6, 6, 6);
        this.setLayout(new TableLayout(3, gbc));
        for (IParameter parameter : effect.getParameters()) {
            JComponent[] cmps = this.pgBuilder.buildGuiFor(parameter, info);
            int i = 0;
            while (i < cmps.length) {
                gbc = (GridBagConstraints)gbc.clone();
                gbc.weightx = this.WEIGHT_X[i % 3];
                this.add((Component)cmps[i], gbc);
                ++i;
            }
        }
    }

    public IEffect getEffect() {
        return this.effect;
    }
}

