/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.gui;

import ch.tachyon.tunnel.engine.gui.AwtTools;
import ch.tachyon.tunnel.engine.gui.EffectControlPanel;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IEffect;
import ch.tachyon.tunnel.host.effect.IGuiListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.TitledBorder;

public class EffectDialog
extends JDialog {
    private final IGuiListener listener;

    public EffectDialog(JFrame parent, IEffect effect, IProcessingInfo info, IGuiListener listener) {
        super(parent, effect.getName(), true);
        this.listener = listener;
        super.setLayout(new BorderLayout());
        EffectControlPanel controlPanel = new EffectControlPanel(effect, info);
        JPanel cp = new JPanel();
        cp.setLayout(new BorderLayout());
        cp.setBorder(new TitledBorder("Parameters"));
        cp.add((Component)controlPanel, "Center");
        this.add((Component)cp, "Center");
        this.add((Component)this.getButtonsPanel(), "South");
        super.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EffectDialog.this.listener.cancel();
            }
        });
    }

    private JPanel getButtonsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 2));
        JPanel okPanel = new JPanel();
        okPanel.setLayout(new FlowLayout());
        panel.add(okPanel);
        AbstractAction okAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EffectDialog.this.listener.process();
            }
        };
        JButton okButton = new JButton(okAction);
        okButton.setText("Ok");
        okButton.setToolTipText("Apply the effect to the selection");
        okButton.setMnemonic('o');
        AwtTools.addKeyboardShortcut((AbstractButton)okButton, 79);
        okPanel.add(okButton);
        if (!System.getProperty("os.name").toLowerCase().equals("mac os x") || !System.getProperty("java.version").startsWith("1.5.")) {
            this.getRootPane().setDefaultButton(okButton);
        }
        JPanel cancelPanel = new JPanel();
        cancelPanel.setLayout(new FlowLayout());
        panel.add(cancelPanel);
        AbstractAction cancelAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                EffectDialog.this.listener.cancel();
            }
        };
        JButton cancelButton = new JButton(cancelAction);
        cancelButton.setText("Cancel");
        cancelButton.setToolTipText("Close this window without applying the effect");
        cancelButton.setMnemonic('c');
        AwtTools.addKeyboardShortcut((AbstractButton)cancelButton, 67);
        AwtTools.addKeyboardShortcut(cancelButton, KeyStroke.getKeyStroke(27, 0), false);
        cancelPanel.add(cancelButton);
        return panel;
    }
}

