/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.gui;

import ch.tachyon.tunnel.engine.gui.ParameterGuiBuilder;
import ch.tachyon.tunnel.host.effect.IParameter;
import ch.tachyon.tunnel.plugin.param.Range;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class EnumControl
extends JPanel {
    private final IParameter parameter;
    private JComboBox comboBox;
    private Object[] values;

    public EnumControl(IParameter parameter) {
        this.parameter = parameter;
        this.values = parameter.getType().getEnumConstants();
        Range range = parameter.getRange();
        if (range != null) {
            int min = Math.max(0, (int)range.minValue());
            int max = Math.min(this.values.length - 1, (int)range.maxValue());
            Object[] subRange = new Object[max - min + 1];
            System.arraycopy(this.values, min, subRange, 0, max - min + 1);
            this.values = subRange;
        }
        this.setLayout(new BorderLayout());
        this.comboBox = new JComboBox<Object>(this.values);
        this.add((Component)this.comboBox, "Center");
        this.comboBox.setSelectedItem(parameter.getInternalValue());
        if (parameter.getDescription() != null) {
            String tooltip = ParameterGuiBuilder.formatMultiLineAsHtml(parameter.getDescription());
            this.comboBox.setToolTipText(tooltip);
        }
        this.comboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EnumControl.this.valueChanged();
            }
        });
        this.valueChanged();
    }

    private void valueChanged() {
        int index = this.comboBox.getSelectedIndex();
        if (index >= 0 && index < this.values.length) {
            this.parameter.setInternalValue(this.values[index]);
        }
    }
}

