/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.gui;

import ch.tachyon.tunnel.engine.ProcessingInfoBridge;
import ch.tachyon.tunnel.engine.gui.ParameterGuiBuilder;
import ch.tachyon.tunnel.host.IProcessingInfo;
import ch.tachyon.tunnel.host.effect.IParameter;
import ch.tachyon.tunnel.plugin.param.Range;
import ch.tachyon.tunnel.plugin.param.ScaleType;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BoxLayout;
import javax.swing.JFormattedTextField;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LongControl
extends JPanel {
    private final IParameter parameter;
    private final IProcessingInfo info;
    private final ScaleType scaleType;
    private final long minValue;
    private final long maxValue;
    private final int sliderMin;
    private final int sliderMax;
    private final boolean identityMapped;
    private JSlider slider;
    private JSpinner spinner;
    private long curValue;
    private boolean isAdjusting = false;

    public LongControl(IParameter parameter, IProcessingInfo info) {
        String tooltip;
        this.parameter = parameter;
        this.info = info;
        this.scaleType = parameter.getScaleType();
        Range range = parameter.getRange();
        this.minValue = range == null ? LongControl.getMinFor(parameter.getType()) : (long)range.minValue();
        this.maxValue = range == null ? LongControl.getMaxFor(parameter.getType()) : (long)range.maxValue();
        this.curValue = this.readValue();
        if (this.minValue > -32768L && this.maxValue < 32767L && this.scaleType.equals((Object)ScaleType.LINEAR)) {
            this.sliderMin = (int)this.minValue;
            this.sliderMax = (int)this.maxValue;
            this.identityMapped = true;
        } else {
            this.sliderMin = 0;
            this.sliderMax = 1000;
            this.identityMapped = false;
        }
        this.setLayout(new BoxLayout(this, 2));
        if (this.minValue > Integer.MIN_VALUE && this.maxValue < Integer.MAX_VALUE) {
            this.slider = new JSlider(0, this.toSlider(this.minValue), this.toSlider(this.maxValue), this.toSlider(this.curValue));
            this.add(this.slider);
            if (parameter.getDescription() != null) {
                tooltip = ParameterGuiBuilder.formatMultiLineAsHtml(parameter.getDescription());
                this.slider.setToolTipText(tooltip);
            }
            this.slider.setMinimum(this.toSlider(this.minValue));
            this.slider.setMaximum(this.toSlider(this.maxValue));
            this.slider.setValue(this.toSlider(this.curValue));
            this.slider.setPaintLabels(false);
            this.slider.setPaintTicks(this.identityMapped);
            if (this.identityMapped) {
                this.slider.setMinorTickSpacing(1);
                if (this.sliderMax - this.sliderMin >= 30) {
                    this.slider.setMajorTickSpacing(10);
                }
            }
            this.slider.setSnapToTicks(this.identityMapped);
            if (UIManager.getLookAndFeel().getName().contains("GTK")) {
                try {
                    this.slider.setFont(this.getFont().deriveFont(0.0f));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            this.slider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent e) {
                    if (LongControl.this.isAdjusting) {
                        return;
                    }
                    LongControl.this.isAdjusting = true;
                    LongControl.this.sliderUpdated();
                    LongControl.this.isAdjusting = false;
                }
            });
            this.slider.setFocusable(false);
        }
        this.spinner = new JSpinner();
        this.add(this.spinner);
        if (parameter.getDescription() != null) {
            tooltip = ParameterGuiBuilder.formatMultiLineAsHtml(parameter.getDescription());
            this.spinner.setToolTipText(tooltip);
        }
        long maxValueT = this.transformValue(this.maxValue);
        long minValueT = this.transformValue(this.minValue);
        long curValueT = this.transformValue(this.curValue);
        SpinnerNumberModel model = new SpinnerNumberModel(curValueT, minValueT, maxValueT, 1.0){

            public Object getNextValue() {
                long curValueT = ((Number)LongControl.this.spinner.getValue()).longValue();
                long curValue = LongControl.this.untransformValue(curValueT);
                long newValue = Math.min(curValue + 1L, LongControl.this.maxValue);
                long newValueT = LongControl.this.transformValue(newValue);
                return newValueT;
            }

            public Object getPreviousValue() {
                long curValueT = ((Number)LongControl.this.spinner.getValue()).longValue();
                long curValue = LongControl.this.untransformValue(curValueT);
                long newValue = Math.max(curValue - 1L, LongControl.this.minValue);
                long newValueT = LongControl.this.transformValue(newValue);
                return newValueT;
            }
        };
        this.spinner.setModel(model);
        final JFormattedTextField textField = ((JSpinner.NumberEditor)this.spinner.getEditor()).getTextField();
        int columns = textField.getColumns();
        if (columns < 5) {
            textField.setColumns(5);
        } else if (columns > 20) {
            textField.setColumns(20);
        }
        textField.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        textField.selectAll();
                    }
                });
            }
        });
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (LongControl.this.isAdjusting) {
                    return;
                }
                LongControl.this.isAdjusting = true;
                LongControl.this.spinnerUpdated();
                LongControl.this.isAdjusting = false;
            }
        });
    }

    private static long getMinFor(Class<?> type) {
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return -128L;
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return -32768L;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return Integer.MIN_VALUE;
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.MIN_VALUE;
        }
        throw new IllegalArgumentException();
    }

    private static long getMaxFor(Class<?> type) {
        if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            return 127L;
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return 32767L;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return Integer.MAX_VALUE;
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.MAX_VALUE;
        }
        throw new IllegalArgumentException();
    }

    private long readValue() {
        Object data = this.parameter.getInternalValue();
        if (data instanceof Number) {
            return ((Number)data).longValue();
        }
        return 0L;
    }

    private void writeValue(long value) {
        Class<?> type = this.parameter.getType();
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            this.parameter.setInternalValue(value);
        } else if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            this.parameter.setInternalValue((int)value);
        } else if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            this.parameter.setInternalValue((short)value);
        } else if (type.equals(Byte.class) || type.equals(Byte.TYPE)) {
            this.parameter.setInternalValue((byte)value);
        }
    }

    private long transformValue(long value) {
        return this.parameter.getTransform().transform(value, new ProcessingInfoBridge(this.info));
    }

    private long untransformValue(long value) {
        return this.parameter.getTransform().untransform(value, new ProcessingInfoBridge(this.info));
    }

    private boolean fireValue(long value) {
        value = Math.max(value, this.minValue);
        if (this.curValue != (value = Math.min(value, this.maxValue))) {
            this.curValue = value;
            this.writeValue(value);
            return true;
        }
        return false;
    }

    private void sliderUpdated() {
        if (this.fireValue(this.fromSlider(this.slider.getValue()))) {
            this.updateSpinner();
        }
    }

    private void spinnerUpdated() {
        if (this.fireValue(this.untransformValue(((Number)this.spinner.getValue()).longValue()))) {
            this.updateSlider();
        }
        this.updateSpinner();
    }

    private void updateSlider() {
        if (this.slider != null) {
            this.slider.setValue(this.toSlider(this.curValue));
        }
    }

    private void updateSpinner() {
        this.spinner.setValue(this.transformValue(this.curValue));
    }

    private double forwScale(long value) {
        double result = this.scaleType.forwScale(value, this.minValue, this.maxValue);
        if (result < (double)this.minValue) {
            result = this.minValue;
        } else if (result > (double)this.maxValue) {
            result = this.maxValue;
        }
        return result;
    }

    private long backScale(double value) {
        double temp = this.scaleType.backScale(value, this.minValue, this.maxValue);
        long result = Math.round(temp);
        if (result < this.minValue) {
            result = this.minValue;
        } else if (result > this.maxValue) {
            result = this.maxValue;
        }
        return result;
    }

    private int toSlider(long value) {
        double temp = this.forwScale(value);
        double sliderRange = this.sliderMax - this.sliderMin;
        double valueRange = this.maxValue - this.minValue;
        double valueOffset = temp - (double)this.minValue;
        return this.sliderMin + (int)Math.round(sliderRange * valueOffset / valueRange);
    }

    private long fromSlider(int value) {
        double sliderRange = this.sliderMax - this.sliderMin;
        double valueRange = this.maxValue - this.minValue;
        double valueOffset = (long)value - this.minValue;
        double res = valueOffset * valueRange / sliderRange + (double)this.minValue;
        return this.backScale(res);
    }
}

