/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

public class TableLayout
extends GridBagLayout {
    private static final long serialVersionUID = 5511537663228706394L;
    private final int nbColumns;
    private GridBagConstraints dfltConstraint = new GridBagConstraints();
    private int x = 0;
    private int y = 0;
    private List<BitSet> reservedColumns = new ArrayList<BitSet>();

    public TableLayout(int nbColumns) {
        this.nbColumns = nbColumns;
    }

    public TableLayout(int nbColumns, GridBagConstraints dfltConstraint) {
        this(nbColumns);
        this.dfltConstraint = (GridBagConstraints)dfltConstraint.clone();
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        GridBagConstraints gbc = (GridBagConstraints)constraints;
        if (gbc == null) {
            gbc = (GridBagConstraints)this.dfltConstraint.clone();
        }
        gbc.gridx = this.x;
        gbc.gridy = this.y;
        if (gbc.gridheight > 1) {
            int i = 1;
            while (i < gbc.gridheight) {
                int j = 0;
                while (j < gbc.gridwidth) {
                    this.reserveColumn(i, this.x + j);
                    ++j;
                }
                ++i;
            }
        }
        if (this.x + gbc.gridwidth > this.nbColumns && this.nbColumns > 0) {
            throw new IllegalArgumentException("Element at column " + this.x + " has width " + gbc.gridwidth + " which is above the number of columns " + this.nbColumns);
        }
        if (gbc.gridwidth < 1) {
            throw new IllegalArgumentException("GridBagConstraint.gridwidth must be > 0");
        }
        super.addLayoutComponent(comp, gbc);
        this.skipCells(gbc.gridwidth);
    }

    public void skipCells(int nbCells) {
        BitSet reserved = this.getReservedColumns();
        int i = 0;
        while (i < nbCells) {
            do {
                ++this.x;
                if (this.nbColumns <= 0 || this.x < this.nbColumns) continue;
                this.x = 0;
                ++this.y;
                this.nextLine();
                reserved = this.getReservedColumns();
            } while (reserved.get(this.x));
            ++i;
        }
    }

    private void nextLine() {
        if (this.reservedColumns.isEmpty()) {
            return;
        }
        this.reservedColumns.remove(0);
    }

    private BitSet getReservedColumns() {
        if (this.reservedColumns.isEmpty()) {
            return new BitSet();
        }
        return this.reservedColumns.get(0);
    }

    private void reserveColumn(int yDelta, int x) {
        while (this.reservedColumns.size() <= yDelta) {
            this.reservedColumns.add(new BitSet());
        }
        BitSet colSet = this.reservedColumns.get(yDelta);
        colSet.set(x);
    }
}

