/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.storage;

import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RunningCache {
    private final IdentityHashMap<Object, Long> objectKeys = new IdentityHashMap();
    private final IdentityHashMap<Object, Element> objectNodes = new IdentityHashMap();
    private long counter = 0L;

    public boolean isDone(Object item) {
        return this.objectNodes.containsKey(item);
    }

    public long getKey(Object item) {
        Long key = this.objectKeys.get(item);
        if (key == null) {
            key = this.counter++;
            this.objectKeys.put(item, key);
        }
        return key;
    }

    public Element getNode(Object item) {
        return this.objectNodes.get(item);
    }

    public void add(Object item, Element node) {
        if (this.objectNodes.containsKey(item)) {
            throw new IllegalArgumentException("Object already added: " + item);
        }
        this.objectNodes.put(item, node);
    }

    public Collection<Object> getReferencedObjects() {
        return Collections.unmodifiableCollection(this.objectKeys.keySet());
    }
}

