/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.storage;

import ch.tachyon.tunnel.engine.storage.BinaryStorage;
import ch.tachyon.tunnel.host.effect.IParameter;
import ch.tachyon.tunnel.host.engine.IPluginBundle;
import ch.tachyon.tunnel.host.engine.IStorage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageImpl
implements IStorage {
    private static final Map<Class<?>, Class<?>> PRIMITIVE_TO_WRAPPED = new HashMap();

    static {
        PRIMITIVE_TO_WRAPPED.put(Boolean.TYPE, Boolean.class);
        PRIMITIVE_TO_WRAPPED.put(Character.TYPE, Character.class);
        PRIMITIVE_TO_WRAPPED.put(Byte.TYPE, Byte.class);
        PRIMITIVE_TO_WRAPPED.put(Short.TYPE, Short.class);
        PRIMITIVE_TO_WRAPPED.put(Integer.TYPE, Integer.class);
        PRIMITIVE_TO_WRAPPED.put(Long.TYPE, Long.class);
        PRIMITIVE_TO_WRAPPED.put(Float.TYPE, Float.class);
        PRIMITIVE_TO_WRAPPED.put(Double.TYPE, Double.class);
    }

    @Override
    public void storeParameterValues(Collection<IParameter> parameters, OutputStream output) throws IOException, InvocationTargetException {
        LinkedHashMap<String, Object> values = new LinkedHashMap<String, Object>();
        for (IParameter param : parameters) {
            values.put(param.getDisplayName(), param.getInternalValue());
        }
        BinaryStorage.save(values, "values", output);
    }

    @Override
    public void loadParameterValues(InputStream input, IPluginBundle bundle, Collection<IParameter> parameters) throws IOException, InvocationTargetException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        Map values = (Map)BinaryStorage.load(input, "values", bundle.getClassLoader(true));
        for (IParameter param : parameters) {
            String name = param.getDisplayName();
            Object value = values.get(name);
            if (value == null || !StorageImpl.isAssignable(value, param.getType())) continue;
            param.setInternalValue(value);
        }
    }

    private static boolean isAssignable(Object value, Class<?> type) {
        if (type.isInstance(value)) {
            return true;
        }
        if (type.isPrimitive()) {
            Class<?> wrappedType = PRIMITIVE_TO_WRAPPED.get(type);
            return wrappedType != null && wrappedType.isInstance(value);
        }
        return false;
    }
}

