/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class CodecInputStream
extends InputStream {
    private static final int BUFFER_SIZE = 1024;
    private final String dstCharset;
    private final Reader reader;
    private byte[] buffer;
    private int available;
    private int index;

    public CodecInputStream(InputStream source, String srcCharset, String dstCharset) {
        this.dstCharset = dstCharset;
        try {
            this.reader = new InputStreamReader(source, srcCharset);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int read() throws IOException {
        char[] chars;
        int amount;
        if (this.index >= this.available && (amount = this.reader.read(chars = new char[1024])) > 0) {
            ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)output, this.dstCharset);
            ((Writer)writer).write(chars, 0, amount);
            ((Writer)writer).flush();
            this.available = output.size();
            this.buffer = output.toByteArray();
            this.index = 0;
        }
        if (this.index >= this.available) {
            return -1;
        }
        return this.buffer[this.index++];
    }
}

