/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicAnnotationHandler
implements InvocationHandler {
    protected final Class<?> annoType;

    public DynamicAnnotationHandler(Class<?> annoType) {
        this.annoType = annoType;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Class<?> type;
        String methodName = method.getName();
        if (methodName.equals("annotationType")) {
            return this.annoType;
        }
        Object result = this.getValue(methodName);
        if (result != null) {
            return result;
        }
        String valueString = this.getValueAsString(methodName);
        if (valueString != null && (result = this.getValue(valueString, type = method.getReturnType())) != null) {
            return result;
        }
        result = method.getDefaultValue();
        if (result != null) {
            return result;
        }
        this.handleNullValue(methodName, method.getReturnType());
        throw new NullPointerException("Property " + methodName + " of annotation type " + this.annoType.getName() + " is null");
    }

    protected void handleNullValue(String methodName, Class<?> type) {
        throw new NullPointerException("Property " + methodName + " of annotation type " + this.annoType.getName() + " is null");
    }

    protected Object getValue(String valueString, Class<?> type) throws Exception {
        if (type.equals(String.class)) {
            return valueString;
        }
        if (type.equals(Class.class)) {
            return Class.forName(valueString);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return Double.parseDouble(valueString);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return Long.parseLong(valueString);
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return Integer.parseInt(valueString);
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(valueString);
        }
        if (Enum.class.isAssignableFrom(type)) {
            Object result = Enum.valueOf(type, valueString);
            return result;
        }
        if (type.isArray()) {
            String[] itemStrings = valueString.split(",");
            if (valueString.trim().equals("")) {
                itemStrings = new String[]{};
            }
            Class<?> cmpType = type.getComponentType();
            Object[] result = (Object[])Array.newInstance(cmpType, itemStrings.length);
            int i = 0;
            while (i < itemStrings.length) {
                result[i] = this.getValue(itemStrings[i], cmpType);
                ++i;
            }
            return result;
        }
        throw new UnsupportedOperationException("Unhandled type: " + type);
    }

    protected Object getValue(String annoMethodName) {
        return null;
    }

    protected String getValueAsString(String annoMethodName) {
        throw new UnsupportedOperationException("getValueAsString() not implemented");
    }

    public static <E extends Annotation> E newAnnotation(Class<E> type, DynamicAnnotationHandler impl) {
        return (E)((Annotation)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)impl));
    }
}

