/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils;

public class FloatQueue {
    private final float[] data;
    private final int capacity;
    private int readPos;
    private int writePos;
    private int size;

    public FloatQueue(int capacity) {
        this(0, capacity);
    }

    public FloatQueue(int initSize, int capacity) {
        if (initSize > capacity) {
            throw new IllegalArgumentException();
        }
        this.capacity = capacity;
        this.data = new float[capacity];
        this.writePos = initSize;
        this.readPos = 0;
        this.size = initSize;
    }

    public int getSize() {
        return this.size;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void push(float value) {
        if (this.size >= this.capacity) {
            throw new IllegalStateException("Buffer overflow");
        }
        this.data[this.writePos] = value;
        this.writePos = (this.writePos + 1) % this.capacity;
        ++this.size;
    }

    public void pushArray(float[] values) {
        this.pushArray(values, values.length);
    }

    public void pushArray(float[] values, int count) {
        this.pushArray(values, 0, count);
    }

    public void pushArray(float[] values, int offset, int count) {
        if (this.size + count > this.capacity) {
            throw new IllegalStateException("Buffer overflow");
        }
        this.size += count;
        while (count > 0) {
            int amount = Math.min(count, this.capacity - this.writePos);
            System.arraycopy(values, offset, this.data, this.writePos, amount);
            this.writePos = (this.writePos + amount) % this.capacity;
            offset += amount;
            count -= amount;
        }
    }

    public float peek() {
        if (this.size == 0) {
            throw new IllegalStateException("Buffer underflow");
        }
        return this.data[this.readPos];
    }

    public float pop() {
        if (this.size == 0) {
            throw new IllegalStateException("Buffer underflow");
        }
        float result = this.data[this.readPos];
        --this.size;
        this.readPos = (this.readPos + 1) % this.capacity;
        return result;
    }

    public void popArray(float[] target) {
        this.popArray(target, 0, target.length);
    }

    public void popArray(float[] target, int offset, int count) {
        if (this.size < count) {
            throw new IllegalStateException("Buffer underflow");
        }
        this.size -= count;
        while (count > 0) {
            int amount = Math.min(count, this.capacity - this.readPos);
            System.arraycopy(this.data, this.readPos, target, offset, amount);
            this.readPos = (this.readPos + amount) % this.capacity;
            offset += amount;
            count -= amount;
        }
    }

    public String toString() {
        return "FloatQueue{capacity=" + this.capacity + ",size=" + this.size + "}";
    }
}

