/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.engine.utils;

public class HistoryBuffer {
    private final float[] data;
    private int index;

    public HistoryBuffer(int capacity) {
        this.data = new float[capacity];
    }

    public void write(float[] input) {
        int i = 0;
        while (i < input.length) {
            this.data[this.index] = input[i];
            this.index = (this.index + 1) % this.data.length;
            ++i;
        }
    }

    public void write(float value) {
        this.data[this.index] = value;
        this.index = (this.index + 1) % this.data.length;
    }

    public void read(int pastOffset, float[] output) {
        this.read(pastOffset, output, output.length);
    }

    public void read(int pastOffset, float[] output, int amount) {
        if (pastOffset > -amount) {
            throw new IllegalArgumentException();
        }
        int offset = (this.index + this.data.length + pastOffset) % this.data.length;
        if (offset < 0) {
            throw new IllegalArgumentException("Read past capacity");
        }
        int i = 0;
        while (i < amount) {
            output[i] = this.data[(i + offset) % this.data.length];
            ++i;
        }
    }

    public float read(int pastOffset) {
        int offset = (this.index + this.data.length + pastOffset) % this.data.length;
        if (offset < 0) {
            throw new IllegalArgumentException("Read past capacity");
        }
        return this.data[offset];
    }
}

